/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bamboo.userauth;

import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.userauth.XsrfCheckAvoider;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Objects;

@BambooComponent
@ExportAsService(value={XsrfCheckAvoider.class})
public class BambooXsrfCheckAvoider
implements XsrfCheckAvoider {
    @Override
    public void avoidXsrfCheck() {
        final HttpServletRequest request = RequestCacheThreadLocal.getRequest();
        if (request != null && Objects.equals(request.getMethod(), "GET") && !Objects.equals(request.getHeader("X-Atlassian-Token"), "no-check")) {
            HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(request){

                public String getHeader(String name) {
                    if ("X-Atlassian-Token".equals(name)) {
                        return "no-check";
                    }
                    return request.getHeader(name);
                }
            };
            RequestCacheThreadLocal.update((HttpServletRequest)requestWrapper);
        }
    }
}

