/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bamboo.userauth;

import com.atlassian.bamboo.user.LoginInformation;
import com.atlassian.bamboo.user.LoginInformationDao;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BambooImport;
import com.atlassian.spring.container.ContainerManager;
import com.resolution.atlasplugins.samlsso.userauth.AbstractRemoteDirectoryAdapter;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
public class BambooRemoteDirectoryAdapter
extends AbstractRemoteDirectoryAdapter {
    private final Logger logger = LoggerFactory.getLogger(BambooRemoteDirectoryAdapter.class);

    @Inject
    public BambooRemoteDirectoryAdapter(@BambooImport DirectoryInstanceLoader directoryInstanceLoader, @BambooImport CrowdService crowdService) {
        super(directoryInstanceLoader, crowdService);
    }

    @Override
    protected boolean isFirstLogin(Principal principal) {
        LoginInformationManager loginInformationManager = (LoginInformationManager)ContainerManager.getComponent((String)"loginInformationManager");
        try {
            Field loginInformationDaoField = LoginInformationManager.class.getDeclaredField("loginInformationDao");
            loginInformationDaoField.setAccessible(true);
            LoginInformationDao loginInformationDao = (LoginInformationDao)loginInformationDaoField.get(loginInformationManager);
            LoginInformation loginInformationByUserName = loginInformationDao.getLoginInformationByUserName(principal.getName());
            if (loginInformationByUserName != null) {
                return loginInformationByUserName.getAuthenticationCount() == 0;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.warn("Could not read login information from user.", (Throwable)e);
        }
        return false;
    }
}

