/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLLoader {
    private static final SAXParserFactory spf = SAXParserFactory.newInstance();

    private XMLLoader() {
    }

    public static <T> T load(String xmlString, Class<T> clazz) {
        return XMLLoader.load(new InputSource(new StringReader(xmlString)), clazz);
    }

    public static <T> T load(InputStream inputStream, Class<T> clazz) {
        return XMLLoader.load(new InputSource(inputStream), clazz);
    }

    private static <T> T load(InputSource inputSource, Class<T> clazz) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Object object;
            Thread.currentThread().setContextClassLoader(XMLLoader.class.getClassLoader());
            try {
                SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), inputSource);
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                Unmarshaller um = jc.createUnmarshaller();
                object = um.unmarshal((Source)xmlSource, clazz).getValue();
            }
            catch (JAXBException | ClassCastException | ParserConfigurationException | SAXException e) {
                throw new XMLLoadFailedException((Exception)e);
            }
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    static {
        try {
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new XMLLoaderInitializationException(e);
        }
    }

    public static class XMLLoadFailedException
    extends RuntimeException {
        public XMLLoadFailedException(Exception cause) {
            super("Loading XML failed", cause);
        }
    }

    public static class XMLLoaderInitializationException
    extends RuntimeException {
        public XMLLoaderInitializationException(Exception cause) {
            super("Initializing XMLLoader failed", cause);
        }
    }
}

