/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.time.ZonedDateTime;

@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SSOPluginInfo {
    private String pluginKey;
    private String version;
    private String hostApplication;
    private String hostApplicationVersion;
    private String licenseType;
    private String licenseSize;
    private String maintenanceExpires;
    private String supportEntitlementNumber;
    private String baseUrl;
    private String requestUrl;
    private String evaluationLicense;

    public SSOPluginInfo() {
    }

    public SSOPluginInfo(ApplicationProperties applicationProperties, PluginLicenseManager licenseManager, PluginAccessor pluginAccessor, HttpServletRequest request) {
        this();
        this.fill(applicationProperties, licenseManager, pluginAccessor, request);
    }

    public void fill(ApplicationProperties applicationProperties, PluginLicenseManager licenseManager, PluginAccessor pluginAccessor, HttpServletRequest request) {
        this.pluginKey = licenseManager.getPluginKey();
        if (licenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)licenseManager.getLicense().get();
            this.licenseType = license.getLicenseType().toString();
            this.licenseSize = license.getEdition().isDefined() ? ((Integer)license.getEdition().get()).toString() : "UNLIMITED";
            try {
                ZonedDateTime maintenanceExpiryDate = license.getMaintenanceExpiryZonedDate().orElse(null);
                this.maintenanceExpires = maintenanceExpiryDate == null ? "NEVER" : maintenanceExpiryDate.toString();
            }
            catch (NoSuchMethodError e) {
                this.maintenanceExpires = "API is not available";
            }
            this.supportEntitlementNumber = license.getSupportEntitlementNumber().isDefined() ? (String)license.getSupportEntitlementNumber().get() : "UNDEFINED";
            this.evaluationLicense = String.valueOf(license.isEvaluation());
        } else {
            this.licenseType = "NONE";
            this.licenseSize = "NONE";
            this.evaluationLicense = "UNDEFINED";
            this.maintenanceExpires = "NONE";
        }
        this.baseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        this.requestUrl = request != null ? request.getRequestURL().toString() : "UNDEFINED";
        Plugin plugin = pluginAccessor.getPlugin(this.pluginKey);
        PluginInformation pluginInfo = plugin.getPluginInformation();
        this.version = pluginInfo.getVersion();
        this.hostApplication = applicationProperties.getDisplayName();
        this.hostApplicationVersion = applicationProperties.getVersion();
    }

    @XmlElement
    public String getPluginKey() {
        return this.pluginKey;
    }

    @XmlElement
    public String getPluginVersion() {
        return this.version;
    }

    @XmlElement
    public String getHostApplication() {
        return this.hostApplication;
    }

    @XmlElement
    public String getHostApplicationVersion() {
        return this.hostApplicationVersion;
    }

    @XmlElement
    public String getLicenseType() {
        return this.licenseType;
    }

    @XmlElement
    public String getLicenseSize() {
        return this.licenseSize;
    }

    @XmlElement
    public String getMaintenanceExpires() {
        return this.maintenanceExpires;
    }

    @XmlElement
    public String getSupportEntitlementNumber() {
        return this.supportEntitlementNumber;
    }

    @XmlElement
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @XmlElement
    public String getRequestUrl() {
        return this.requestUrl;
    }

    @XmlElement
    public String getIsEvaluationLicense() {
        return this.evaluationLicense;
    }
}

