/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RemoveSamlWrapperService {
    private static final Logger logger = LoggerFactory.getLogger(RemoveSamlWrapperService.class);
    private static final String SAML_WRAPPER_PLUGIN_KEY = "com.resolution.samlwrapper-plugin";
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;

    @Inject
    public RemoveSamlWrapperService(@ComponentImport EventPublisher eventPublisher, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginController pluginController) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
    }

    @EventListener
    public void removeSamlWrapperAfterBeingEnabled(PluginEnabledEvent pluginEnabledEvent) {
        this.eventPublisher.unregister((Object)this);
        Plugin samlWrapperPlugin = this.pluginAccessor.getPlugin(SAML_WRAPPER_PLUGIN_KEY);
        if (samlWrapperPlugin == null) {
            logger.debug("{} seems not to be installed, done here.", (Object)SAML_WRAPPER_PLUGIN_KEY);
        } else {
            logger.debug("Uninstalling {}", (Object)SAML_WRAPPER_PLUGIN_KEY);
            try {
                this.pluginController.uninstall(samlWrapperPlugin);
                logger.info("Uninstalled {}", (Object)SAML_WRAPPER_PLUGIN_KEY);
            }
            catch (PluginException e) {
                logger.warn("Uninstalling {} failed.", (Object)SAML_WRAPPER_PLUGIN_KEY, (Object)e);
            }
        }
    }
}

