/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AgingMap<K, V> {
    private final Map<K, V> valueMap = new ConcurrentHashMap();
    private final Map<K, Long> timestampMap = new ConcurrentHashMap<K, Long>();
    public static final long DEFAULT_MAX_AGE = 3600000L;
    private final long maxAge;

    public AgingMap() {
        this(3600000L);
    }

    public AgingMap(long maxAge) {
        this.maxAge = maxAge;
    }

    public V get(@Nullable K key) {
        if (key == null) {
            return null;
        }
        this.cleanup();
        return this.valueMap.get(key);
    }

    public synchronized void put(K key, V value) {
        long now = System.currentTimeMillis();
        this.valueMap.put(key, value);
        this.timestampMap.put(key, now);
    }

    public synchronized void remove(K key) {
        this.valueMap.remove(key);
        this.timestampMap.remove(key);
    }

    private synchronized void cleanup() {
        long minTimestamp = System.currentTimeMillis() - this.maxAge;
        ArrayList<K> keysToDelete = new ArrayList<K>();
        for (Map.Entry<K, Long> current : this.timestampMap.entrySet()) {
            if (current.getValue() >= minTimestamp) continue;
            keysToDelete.add(current.getKey());
        }
        for (Map.Entry<K, Long> currentKey : keysToDelete) {
            this.valueMap.remove(currentKey);
            this.timestampMap.remove(currentKey);
        }
    }
}

