/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi.oauth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorStorageWrapper;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.oauth.AbstractOAuthFlow;
import de.resolution.usersync.spi.oauth.OAuthClientCredentialsFlow;
import java.time.Instant;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuthClientCredentialsFlowImpl
extends AbstractOAuthFlow
implements OAuthClientCredentialsFlow {
    private static final Logger logger = LoggerFactory.getLogger(OAuthClientCredentialsFlowImpl.class);

    protected OAuthClientCredentialsFlowImpl(@Nonnull HTTPWrapper httpWrapper, @Nonnull String baseUrl, @Nonnull String tokenUrl, @Nullable String clientId, @Nullable String clientSecret, @Nonnull Set<String> scope, @Nonnull ConnectorStorageWrapper connectorStorageWrapper) {
        super(httpWrapper, baseUrl, tokenUrl, clientId, clientSecret, scope, connectorStorageWrapper);
    }

    @Override
    public void refreshAccessToken() throws AccessTokenException {
        if (StringUtil.isNullOrEmpty((String)this.clientId) || StringUtil.isNullOrEmpty((String)this.clientSecret)) {
            throw new AccessTokenException("Incomplete configuration, cannot request access token.");
        }
        HashMap<Object, Object> formData = new HashMap<Object, Object>();
        formData.put("client_id", this.clientId);
        formData.put("client_secret", this.clientSecret);
        formData.put("grant_type", "client_credentials");
        if (!this.getScope().isEmpty()) {
            formData.put("scope", String.join((CharSequence)" ", this.getScope()));
        }
        this.executeTokenRequest(formData);
    }

    @Override
    public void validateToken(@Nonnull String token, @Nullable String expiryDate) throws AccessTokenException {
        Instant exp;
        Instant nbf;
        Instant iat;
        DecodedJWT jwt;
        super.validateToken(token, expiryDate);
        try {
            jwt = JWT.decode((String)token);
        }
        catch (JWTDecodeException exception) {
            logger.debug("JWT validation of access token not possible. The token may not be a JWT. {}", (Object)this.redactToken(token), (Object)exception);
            return;
        }
        Instant now = Instant.now();
        if (jwt.getIssuedAt() != null && (iat = jwt.getIssuedAt().toInstant()).isAfter(now)) {
            throw new AccessTokenException("'iat' claim is in the future: " + iat);
        }
        if (jwt.getNotBefore() != null && (nbf = jwt.getNotBefore().toInstant()).isAfter(now)) {
            throw new AccessTokenException("'nbf' claim is in the future: " + nbf);
        }
        if (jwt.getExpiresAt() != null && (exp = jwt.getExpiresAt().toInstant()).isBefore(now)) {
            throw new AccessTokenException("'exp' claim is in the past: " + exp);
        }
    }

    @Override
    @Nonnull
    public ConnectionTestResultEntity.EndpointResult doAccessTokenConnectionTest() {
        this.resetAuthorization();
        try {
            this.refreshAccessToken();
        }
        catch (AccessTokenException ex) {
            return ConnectionTestResultEntity.EndpointResult.createError("Fetch Access Token", this.getTokenUrl(), false, ex.getStatusCode() + "", ex.getMessage(), "Please check the details below");
        }
        return ConnectionTestResultEntity.EndpointResult.create("Fetch Access Token", this.getTokenUrl(), true, "OK", null);
    }

    @Override
    public boolean isAuthorizationRequired() {
        return !this.connectorStorageWrapper.getValue("ACCESS_TOKEN").isPresent();
    }
}

