/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import de.resolution.usersync.heartbeat.LocalHeartbeatReceiver;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@JiraComponent
public class JiraHeartbeatReceiver
extends LocalHeartbeatReceiver
implements ClusterMessageConsumer,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(JiraHeartbeatReceiver.class);
    private final ClusterMessagingService clusterMessagingService = Objects.requireNonNull((ClusterMessagingService)ComponentAccessor.getComponent(ClusterMessagingService.class));

    @Inject
    public JiraHeartbeatReceiver() {
        this.clusterMessagingService.registerListener("usersync.heartbeat", (ClusterMessageConsumer)this);
    }

    public void receive(@Nonnull String channel, @Nonnull String message, @Nonnull String senderId) {
        LocalHeartbeatReceiver.IdAndTimestamp idAndTimestamp;
        if (channel.equals("usersync.heartbeat") && (idAndTimestamp = LocalHeartbeatReceiver.splitMessage(message)) != null) {
            this.addHeartbeat(idAndTimestamp.getId(), idAndTimestamp.getTimestamp());
        }
    }

    public void destroy() throws Exception {
        logger.debug("Unregistering from ClusterMessagingService");
        this.clusterMessagingService.unregisterListener((ClusterMessageConsumer)this);
    }
}

