/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.scim.rest;

import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.exceptions.UnauthorizedException;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.net.IPRangeChecker;
import de.resolution.commons.task.api.Task;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.Tuple;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.SyncStatusRepository;
import de.resolution.usersync.builtin.scim.ScimConnector;
import de.resolution.usersync.builtin.scim.ScimConnectorConfiguration;
import de.resolution.usersync.builtin.scim.exception.ScimExceptionWrapper;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.impl.SyncStatusAoProxy;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResource {
    protected static final String PATH_PARAM_ID = "id";
    protected static final String PATH_PARAM_CONNECTOR_ID = "connectorId";
    protected static final String QUERY_PARAM_ATTRIBUTES = "attributes";
    protected static final String QUERY_PARAM_EXCLUDE_ATTRIBUTES = "excludedAttributes";
    protected static final String QUERY_PARAM_FILTER = "filter";
    protected static final String QUERY_PARAM_START_INDEX = "startIndex";
    protected static final String QUERY_PARAM_COUNT = "count";
    public static final CacheControl ccNoCache = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final Logger logger = LoggerFactory.getLogger(AbstractResource.class);
    private final ConnectorService connectorService;
    private final PrivilegeChecker privilegeChecker;
    private final LicenseChecker licenseChecker;
    private final SyncStatusRepository syncStatusRepository;

    protected AbstractResource(@Nonnull ConnectorService connectorService, @Nonnull PrivilegeChecker privilegeChecker, @Nonnull LicenseChecker licenseChecker, @Nonnull SyncStatusRepository syncStatusRepository) {
        this.connectorService = connectorService;
        this.privilegeChecker = privilegeChecker;
        this.licenseChecker = licenseChecker;
        this.syncStatusRepository = syncStatusRepository;
    }

    @Nonnull
    private Tuple<ScimConnector, SyncStatusFacade> checkPrivilegesAndGetConnectorAndSyncStatus(@Nonnull HttpServletRequest request, @Nullable String connectorId, boolean createOrUpdateSyncStatus) throws ScimExceptionWrapper {
        SyncStatusFacade syncStatusFacade = SyncStatusFacade.nullFacade();
        try {
            LicenseStatus licenseStatus;
            ScimConnector scimConnector = this.loadConnector(connectorId);
            if (createOrUpdateSyncStatus) {
                SyncStatusAoProxy syncStatus = this.syncStatusRepository.getLast(scimConnector.getUniqueId());
                long intervalInMilliseconds = ((ScimConnectorConfiguration)scimConnector.getConfiguration()).getMaxSyncResultAge() * 60L * 1000L;
                if (syncStatus != null && new Date().getTime() - syncStatus.getCreatedTime() <= intervalInMilliseconds) {
                    syncStatusFacade = syncStatus.facade();
                } else {
                    if (syncStatus != null) {
                        syncStatus.setStatus(Task.Status.DONE);
                    }
                    syncStatus = this.syncStatusRepository.create(scimConnector.getUniqueId(), false, false);
                    syncStatus.setStatus(Task.Status.LISTENING);
                    syncStatusFacade = syncStatus.facade();
                    this.syncStatusRepository.cleanup(scimConnector.getUniqueId(), ((ScimConnectorConfiguration)scimConnector.getConfiguration()).getResultsToKeep());
                }
            }
            if (!(licenseStatus = this.licenseChecker.checkLicense()).isLicensed()) {
                throw new ForbiddenException("User Sync is not licensed");
            }
            this.checkIPRange(request, scimConnector);
            switch (((ScimConnectorConfiguration)scimConnector.getConfiguration()).getAuthMethod()) {
                case BASIC: {
                    this.verifySysAdminPermission(request);
                    break;
                }
                case TOKEN: {
                    this.validateBearerToken(request, ((ScimConnectorConfiguration)scimConnector.getConfiguration()).getToken());
                    break;
                }
                default: {
                    throw new UnauthorizedException("Invalid authentication method");
                }
            }
            return new Tuple((Object)scimConnector, (Object)syncStatusFacade);
        }
        catch (ScimException e) {
            throw new ScimExceptionWrapper(e, syncStatusFacade.getSyncStatus());
        }
    }

    private void checkIPRange(@Nonnull HttpServletRequest request, @Nonnull ScimConnector scimConnector) throws ForbiddenException {
        ScimConnectorConfiguration config = (ScimConnectorConfiguration)scimConnector.getConfiguration();
        if (config.getAllowedIPs().isEmpty()) {
            return;
        }
        if (!IPRangeChecker.isInRange((HttpServletRequest)request, config.getAllowedIPs(), (String)(config.isReverseProxySupportEnabled() ? config.getRealIpAddressHeaderName() : null), config.isReverseProxySupportEnabled() ? config.getTrustedReverseProxyIpAddresses() : null)) {
            throw new ForbiddenException("Request coming from an invalid IP or IP range");
        }
    }

    private void verifySysAdminPermission(@Nonnull HttpServletRequest request) throws ForbiddenException {
        try {
            this.privilegeChecker.checkSysAdmin(request);
        }
        catch (InsufficientUserPrivilegeException e) {
            throw new ForbiddenException(e.getMessage(), null, (Throwable)e);
        }
    }

    private void validateBearerToken(@Nonnull HttpServletRequest request, @Nonnull String tokenFromConfig) throws UnauthorizedException {
        String authorizationHeader = request.getHeader("Authorization");
        String valuePrefix = "Bearer ";
        if (StringUtil.isNullOrEmpty((String)authorizationHeader)) {
            throw new UnauthorizedException("The request did not contain a valid bearer token");
        }
        if (!authorizationHeader.startsWith(valuePrefix)) {
            throw new UnauthorizedException("The request did not contain a valid bearer token");
        }
        String receivedToken = authorizationHeader.substring(valuePrefix.length());
        if (!tokenFromConfig.equals(receivedToken)) {
            throw new UnauthorizedException("Invalid bearer token");
        }
    }

    @Nonnull
    private ScimConnector loadConnector(@Nullable String connectorId) throws BadRequestException, ServerErrorException {
        Object connector;
        if (connectorId == null || connectorId.isEmpty()) {
            throw BadRequestException.invalidValue((String)"Undefined connectorId");
        }
        try {
            connector = this.connectorService.getConnectorByUniqueId(connectorId).getConnector();
        }
        catch (ConnectorNotFoundException e) {
            throw BadRequestException.invalidValue((String)"Unknown connectorId");
        }
        catch (ConnectorFactoryNotAvailableException e) {
            throw new ServerErrorException("Connector factory not available", null, (Throwable)e);
        }
        catch (ConfigurationFailedException e) {
            throw new ServerErrorException("Unable to load connector configuration", null, (Throwable)e);
        }
        if (connector instanceof ScimConnector) {
            return (ScimConnector)connector;
        }
        throw BadRequestException.invalidValue((String)("Connector is of type " + connector.getTypeDisplayName() + ", but " + "SCIM 2.0" + " was expected."));
    }

    @Nonnull
    protected Response handleScimRequest(@Nullable String connectorId, @Nonnull HttpServletRequest request, @Nullable String requestBody, boolean createOrUpdateSyncStatus, @Nonnull ScimRequestHandler function) throws ScimExceptionWrapper {
        SyncStatus syncStatus = null;
        try {
            Tuple<ScimConnector, SyncStatusFacade> connectorAndSyncStatus = this.checkPrivilegesAndGetConnectorAndSyncStatus(request, connectorId, createOrUpdateSyncStatus);
            SyncStatusFacade facade = (SyncStatusFacade)connectorAndSyncStatus.right();
            syncStatus = facade.getSyncStatus();
            Response response = function.execute((ScimConnector)connectorAndSyncStatus.left(), facade);
            if (createOrUpdateSyncStatus) {
                Long syncStatusId = syncStatus != null ? Long.valueOf(syncStatus.getId()) : null;
                Response.Status responseStatus = Response.Status.fromStatusCode((int)response.getStatus());
                String responseBody = response.getEntity() != null ? response.getEntity().toString() : null;
                this.logHttpRequest(syncStatusId, request, requestBody, responseStatus, responseBody);
            }
            return response;
        }
        catch (ScimException e) {
            if (createOrUpdateSyncStatus) {
                Long syncStatusId = syncStatus != null ? Long.valueOf(syncStatus.getId()) : null;
                Response.Status responseStatus = Response.Status.fromStatusCode((int)e.getScimError().getStatus());
                String responseBody = e.getScimError().getDetail();
                this.logHttpRequest(syncStatusId, request, requestBody, responseStatus, responseBody);
            }
            throw new ScimExceptionWrapper(e, syncStatus);
        }
    }

    protected void logHttpRequest(@Nullable Long syncStatusId, @Nonnull HttpServletRequest request, @Nullable String requestBody, @Nonnull Response.Status responseStatus, @Nullable String responseBody) {
        String requestPath;
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        String method = request.getMethod();
        String scimPath = requestPath = request.getRequestURI();
        if (requestPath.contains("/scim/v2/")) {
            scimPath = requestPath.substring(requestPath.indexOf("/scim/v2/") + 8);
        }
        StringBuilder logMessage = new StringBuilder();
        logMessage.append("[Incoming SCIM request");
        if (syncStatusId != null) {
            logMessage.append(" - Sync Status ID: ").append(syncStatusId);
        }
        logMessage.append("]\n");
        logMessage.append(">>> ").append(method).append(" ").append(scimPath);
        if (requestBody != null && !requestBody.isEmpty()) {
            String formattedRequestBody = JSONUtil.isValidJson((String)requestBody) ? JSONUtil.prettify((String)requestBody) : requestBody;
            logMessage.append("\n").append(formattedRequestBody);
        }
        logMessage.append("\n<<< ").append(responseStatus.getStatusCode()).append(" ").append(responseStatus.getReasonPhrase());
        if (responseBody != null && !responseBody.isEmpty()) {
            String formattedResponseBody = JSONUtil.isValidJson((String)responseBody) ? JSONUtil.prettify((String)responseBody) : responseBody;
            logMessage.append("\n").append(formattedResponseBody);
        }
        this.logger.debug(logMessage.toString());
    }

    @FunctionalInterface
    public static interface ScimRequestHandler {
        public Response execute(@Nonnull ScimConnector var1, @Nonnull SyncStatusFacade var2) throws ScimException;
    }
}

