/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.tracker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerInfo;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTrackerRepository;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/{a:tracker|trucker}")
public class AuthenticationTrackerRestResource {
    private final AuthenticationTrackerRepository repository;
    private final PrivilegeChecker privilegeChecker;

    @Inject
    public AuthenticationTrackerRestResource(AuthenticationTrackerRepository repository, PrivilegeChecker privilegeChecker) {
        this.repository = repository;
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Produces(value={"application/json"})
    public Response createTracker(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        AuthenticationTracker tracker = (AuthenticationTracker)this.repository.create();
        return Response.ok((Object)Utils.asJson(tracker)).cacheControl(Utils.ccNoCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response getTracker(@PathParam(value="id") String id, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        String uppercaseId = id.toUpperCase();
        if (this.repository.has(uppercaseId)) {
            AuthenticationTracker tracker = (AuthenticationTracker)this.repository.get(uppercaseId, false);
            return Response.ok().entity((Object)Utils.asJson(tracker)).cacheControl(Utils.ccNoCache).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(Utils.ccNoCache).build();
    }

    private long prepareTimeValuesFromFrontend(long value) {
        return value != -1L ? System.currentTimeMillis() - value * 60000L : value;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/list")
    public Response getTrackerList(@QueryParam(value="page") @DefaultValue(value="0") int page, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="fromCreated") @DefaultValue(value="-1") long fromCreated, @QueryParam(value="untilCreated") @DefaultValue(value="-1") long untilCreated, @QueryParam(value="fromLastModified") @DefaultValue(value="-1") long fromLastModified, @QueryParam(value="untilLastModified") @DefaultValue(value="-1") long untilLastModified, @QueryParam(value="samlStatuses") List<SAMLAuthenticationTracker.SamlStatus> samlStatuses, @QueryParam(value="statuses") List<SAMLAuthenticationTracker.Status> statuses, @QueryParam(value="orderBy") @DefaultValue(value="CREATED") SAMLAuthenticationTrackerRepository.OrderBy orderBy, @QueryParam(value="count") @DefaultValue(value="50") int count, @QueryParam(value="descending") @DefaultValue(value="false") boolean descending, @QueryParam(value="userIdOrTrackerId") @DefaultValue(value="") String userIdOrTrackerId, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        int effectivePage = page >= 0 ? page : 0;
        int effectiveLimit = limit > 0 ? limit : 10;
        long offsetAsLong = (long)effectivePage * (long)effectiveLimit;
        int offset = offsetAsLong < Integer.MAX_VALUE ? (int)offsetAsLong : Integer.MAX_VALUE;
        long actualFromCreated = this.prepareTimeValuesFromFrontend(fromCreated);
        long actualUntilCreated = this.prepareTimeValuesFromFrontend(untilCreated);
        long actualFromLastModified = this.prepareTimeValuesFromFrontend(fromLastModified);
        long actualUntilLastModified = this.prepareTimeValuesFromFrontend(untilLastModified);
        int total = this.repository.count(actualFromCreated, actualUntilCreated, actualFromLastModified, actualUntilLastModified, statuses, samlStatuses, userIdOrTrackerId);
        List<AuthenticationTracker> trackers = this.repository.find(actualFromCreated, actualUntilCreated, actualFromLastModified, actualUntilLastModified, statuses, samlStatuses, SAMLAuthenticationTrackerRepository.OrderBy.CREATED, offset, limit, true, userIdOrTrackerId);
        ArrayList<AuthenticationTrackerInfo> trackerInfos = new ArrayList<AuthenticationTrackerInfo>(trackers.size());
        for (AuthenticationTracker tracker : trackers) {
            trackerInfos.add(new AuthenticationTrackerInfo(tracker));
        }
        HashMap<String, Serializable> responseMap = new HashMap<String, Serializable>();
        responseMap.put("total", Integer.valueOf(total));
        responseMap.put("content", trackerInfos);
        return Response.ok((Object)Utils.asJson(responseMap)).build();
    }

    @DELETE
    public Response deleteAll(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        this.repository.cleanup(-1L);
        return Response.noContent().cacheControl(Utils.ccNoCache).build();
    }
}

