/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.azure;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.resolution.usersync.builtin.azure.AzureConnectorConfigurationImpl;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import de.resolution.usersync.spi.ProfilePictureCapableConnectorConfiguration;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonDeserialize(as=AzureConnectorConfigurationImpl.class)
public interface AzureConnectorConfiguration
extends OAuthConnectorConfiguration,
ProfilePictureCapableConnectorConfiguration {
    @Nonnull
    public GrantType getGrantType();

    @Nonnull
    public String getAzureEndpoint();

    @Nonnull
    public String getGraphEndpoint();

    @Nonnull
    public String getDirectoryTenantId();

    @Nonnull
    public Set<String> getScope();

    @Nonnull
    public APIVersion getApiVersion();

    public boolean isFetchGroupMemberships();

    public boolean isFetchSecurityGroups();

    public boolean isFetchMailEnabledSecurityGroups();

    public boolean isFetchDistributionGroups();

    public boolean isFetchOffice365GroupsSecurityEnabled();

    public boolean isFetchOffice365GroupsNonSecurityEnabled();

    public boolean isFetchManager();

    @Nonnull
    public String getProfilePictureSize();

    @Nonnull
    public List<String> getAdditionalAzureAttributes();

    public boolean isGroupSyncDisabled();

    public boolean isAddGroupOnPremisesSamAccountNameToUser();

    public static enum GrantType {
        CLIENT_CREDENTIALS,
        AUTHORIZATION_CODE;

    }

    public static enum APIVersion {
        V1_0("v1.0"),
        BETA("beta");

        private final String urlPart;

        private APIVersion(String urlPart) {
            this.urlPart = urlPart;
        }

        public String getUrlPart() {
            return this.urlPart;
        }
    }
}

