/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.retransform.frontend;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.AttributeTransformationConfigTranslator;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Named(value="retransformRestResource")
@Path(value="/retransform")
public class RetransformRestResource {
    private final PrivilegeChecker privilegeChecker;
    private final AtlasUserAdapter atlasUserAdapter;

    @Inject
    public RetransformRestResource(PrivilegeChecker privilegeChecker, AtlasUserAdapter atlasUserAdapter) {
        this.privilegeChecker = privilegeChecker;
        this.atlasUserAdapter = atlasUserAdapter;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/runtransformation")
    @POST
    public Response runTransformation(String jsonString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkAdmin(request);
        RunTransformationInputEntity inputEntity = (RunTransformationInputEntity)JSONUtil.fromJson((String)jsonString, RunTransformationInputEntity.class);
        AttributeTransformationConfig transformationConfig = inputEntity.getAttributeTransformationConfig();
        MapStructuredData testData = inputEntity.getTestData() == null ? StructuredData.create() : StructuredData.create(inputEntity.getTestData());
        try {
            Map transformerMap = new AttributeTransformationConfigTranslator(Collections.singletonList(transformationConfig)).withDefaultTopLevelKey(inputEntity.getDefaultTopLevelKey()).withHandleValuesAsExpressions(inputEntity.isHandleValuesAsExpressions()).withAtlasUserAdapter(this.atlasUserAdapter).translate();
            AttributeTransformer attributeTransformer = (AttributeTransformer)transformerMap.values().iterator().next();
            AttributeTransformationResult transformationResult = attributeTransformer.transform((StructuredData)testData);
            return Response.ok((Object)JSONUtil.asJson((Object)new RunTransformationResultEntity(true, transformationResult, null))).build();
        }
        catch (TransformationFailedException e) {
            return Response.ok((Object)JSONUtil.asJson((Object)new RunTransformationResultEntity(false, null, e.getMessage()))).build();
        }
    }

    private static class RunTransformationInputEntity {
        private final AttributeTransformationConfig attributeTransformationConfig;
        private final Map<String, Object> testData;
        private final String defaultTopLevelKey;
        private final boolean handleValuesAsExpressions;

        @JsonCreator
        public RunTransformationInputEntity(@JsonProperty(value="transformationConfig") AttributeTransformationConfig attributeTransformationConfig, @JsonProperty(value="testData") Map<String, Object> testData, @JsonProperty(value="defaultTopLevelKey") String defaultTopLevelKey, @JsonProperty(value="handleValuesAsExpressions") boolean handleValuesAsExpressions) {
            this.attributeTransformationConfig = attributeTransformationConfig;
            this.testData = testData;
            this.defaultTopLevelKey = defaultTopLevelKey;
            this.handleValuesAsExpressions = handleValuesAsExpressions;
        }

        public AttributeTransformationConfig getAttributeTransformationConfig() {
            return this.attributeTransformationConfig;
        }

        public Map<String, Object> getTestData() {
            return this.testData;
        }

        public String getDefaultTopLevelKey() {
            return this.defaultTopLevelKey;
        }

        public boolean isHandleValuesAsExpressions() {
            return this.handleValuesAsExpressions;
        }
    }

    private static class RunTransformationResultEntity {
        private final boolean success;
        private final AttributeTransformationResult transformationResult;
        private final String errorMsg;

        public RunTransformationResultEntity(boolean success, AttributeTransformationResult transformationResult, String errorMsg) {
            this.success = success;
            this.transformationResult = transformationResult;
            this.errorMsg = errorMsg;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public AttributeTransformationResult getTransformationResult() {
            return this.transformationResult;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }
}

