/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.validation;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.Defaults;
import com.resolution.atlasplugins.samlsso.LogoutRedirectRecommendedWarningService;
import com.resolution.atlasplugins.samlsso.Platform7Util;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.EmailDomainIdpId;
import com.resolution.atlasplugins.samlsso.configuration.HeaderValueIdpId;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MetadataIntoConfigurationMerger;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.metadata.Contact;
import com.resolution.samlwrapper.api.metadata.MetadataInformation;
import com.resolution.samlwrapper.api.metadata.StringWithLang;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlascompat.api.JiraServiceDeskApi;
import de.resolution.commons.cert.api.CertUtil;
import de.resolution.commons.cert.api.CertificateCheckResult;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.validate.api.TopLevelValidator;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.commons.validate.api.Validator;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ConfigurationDataValidator.class})
public class ConfigurationDataValidator
implements TopLevelValidator<ConfigurationData> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationDataValidator.class);
    private static final String REDIRECT_CHECKER_BLOCKED_STRINGS = "redirectCheckerBlockedStrings";
    private final CertUtil certUtil;
    private final Validator<SamlIdpConfigurationData, ConfigurationData> samlIdpConfigurationValidator;
    private final Validator<OidcIdpConfigurationData, ConfigurationData> oidcIdpConfigurationValidator;
    private final Validator<MetadataInformation, Void> metadataInformationValidator;
    private final LogoutRedirectRecommendedWarningService logoutRedirectRecommendedWarningService;
    private final AtlasCompatApiFactory atlasCompatApiFactory;
    private final CronExpressionValidator cronExpressionValidator;
    private final Platform7Util platform7Util;
    private static final String TEMPLATE_MUST_NOT_BE_EMPTY = "Template must not be empty";
    private static final String EMAIL_DOMAIN = "emailDomain";
    private static final String IDP_ID = "idpId";
    private final Validator<OAuth2IdpConfigurationData, ConfigurationData> oAuth2IdpConfigurationDataConfigurationDataValidator;

    @Inject
    public ConfigurationDataValidator(Validator<SamlIdpConfigurationData, ConfigurationData> samlIdpConfigurationValidator, Validator<MetadataInformation, Void> metadataInformationValidator, LogoutRedirectRecommendedWarningService logoutRedirectRecommendedWarningService, Validator<OidcIdpConfigurationData, ConfigurationData> oidcIdpConfigurationValidator, SAMLWrapper samlWrapper, AtlasCompatApiFactory atlasCompatApiFactory, Validator<OAuth2IdpConfigurationData, ConfigurationData> oAuth2IdpConfigurationDataConfigurationDataValidator, CronExpressionValidator cronExpressionValidator, Platform7Util platform7Util) {
        this.samlIdpConfigurationValidator = samlIdpConfigurationValidator;
        this.metadataInformationValidator = metadataInformationValidator;
        this.certUtil = samlWrapper.getCertUtil();
        this.logoutRedirectRecommendedWarningService = logoutRedirectRecommendedWarningService;
        this.oidcIdpConfigurationValidator = oidcIdpConfigurationValidator;
        this.oAuth2IdpConfigurationDataConfigurationDataValidator = oAuth2IdpConfigurationDataConfigurationDataValidator;
        this.atlasCompatApiFactory = atlasCompatApiFactory;
        this.cronExpressionValidator = cronExpressionValidator;
        this.platform7Util = platform7Util;
    }

    public ValidationResult validate(ConfigurationData configurationData) {
        CertificateCheckResult commonCertCheckResult;
        CertificateCheckResult checkResult;
        int i;
        ValidationResult result = ValidationResult.create();
        if (!configurationData.serviceDeskPortalsToRedirect.isEmpty()) {
            Map portals;
            Set<Object> currentPortalIds = Collections.emptySet();
            JiraServiceDeskApi jiraServiceDeskApi = this.atlasCompatApiFactory.getJiraServiceDeskApi().orElse(null);
            if (jiraServiceDeskApi != null && (portals = jiraServiceDeskApi.getPortalIdsAndNames()) != null) {
                currentPortalIds = portals.keySet();
            }
            ValidationResult portalsResult = ValidationResult.create();
            for (i = 0; i < configurationData.serviceDeskPortalsToRedirect.size(); ++i) {
                String value = configurationData.serviceDeskPortalsToRedirect.get(i);
                if (value == null || value.isEmpty()) {
                    portalsResult.add(i, "Value must not be empty.");
                    continue;
                }
                try {
                    Integer valueAsInt = Integer.parseInt(value);
                    if (currentPortalIds.contains(valueAsInt)) continue;
                    portalsResult.add(i, null, "Portal " + value + " does not exist.");
                    continue;
                }
                catch (NumberFormatException e) {
                    portalsResult.add(i, value + " is not numeric.");
                }
            }
            result.add("serviceDeskPortalsToRedirect", portalsResult);
        }
        if (configurationData.setSameSiteAttributeOnSessionCookie && this.platform7Util.isUpdatingCookiesRestricted()) {
            result.add("setSameSiteAttributeOnSessionCookie", null, "This setting has no effect.");
        }
        if (configurationData.clockSkew < 0) {
            result.add("clockSkew", "Clock skew must be > 0", null);
        }
        if (!(checkResult = this.certUtil.check(configurationData.certificatePEM, configurationData.privateKeyPEM)).hasPrivateKey()) {
            result.add("privateKeyPEM", "The private key must not be empty", null);
        }
        if (!checkResult.isValid()) {
            result.add("certificatePEM", "Certificate/Private key is not valid: " + checkResult.getMessage(), null);
        }
        if (configurationData.entityId == null || configurationData.entityId.trim().isEmpty()) {
            result.add("entityId", "Entity Id must not be empty", null);
        }
        if (configurationData.defaultRedirectUrl == null || configurationData.defaultRedirectUrl.trim().isEmpty()) {
            result.add("defaultRedirectUrl", "Default Redirect URL must be set, reset to default if unsure.", null);
        }
        if (configurationData.useTrackerCleanupCronExpression && !this.cronExpressionValidator.isValid(configurationData.trackerCleanupCronExpression)) {
            result.add("trackerCleanupCronExpression", "Cron expression is not valid", null);
        }
        if (configurationData.trackerCleanupIntervalInMinutes <= 0) {
            result.add("trackerCleanupIntervalInMinutes", "Interval must be > 0", null);
        }
        if (configurationData.trackerStorageHours <= 0) {
            result.add("trackerStorageHours", "Storage hours must be > 0", null);
        }
        if (configurationData.responseIdStorageIntervalInHours < 0) {
            result.add("responseIdStorageIntervalInHours", "Storage hours must be >= 0", null);
        }
        if (configurationData.responseIdStorageIntervalInHours == 0) {
            result.add("responseIdStorageIntervalInHours", null, "Response Ids will be deleted on next cleanup!");
        }
        if (configurationData.reloadMetadataIntervalInMinutes < 1) {
            result.add("reloadMetadataIntervalInMinutes", "Interval must be > 0", null);
        }
        result.add("metadataInformation", this.metadataInformationValidator.validate((Object)configurationData.metadataInformation, null));
        this.checkStringArrayForEmptyStrings(configurationData.commonMetadataIdpsToSkip, result, "commonMetadataIdpsToSkip", "IdP to skip");
        if (configurationData.idpNameFromMetadataExpression == null || configurationData.idpNameFromMetadataExpression.trim().isEmpty()) {
            result.add("idpNameFromMetadataExpression", "IdP name expression must be set", null);
        } else {
            try {
                MetadataIntoConfigurationMerger.createGenerateNameForIdpScript(configurationData.idpNameFromMetadataExpression);
            }
            catch (Exception e) {
                result.add("idpNameFromMetadataExpression", e.getMessage());
            }
        }
        if (configurationData.errorPageTemplate == null || configurationData.errorPageTemplate.trim().isEmpty()) {
            result.add("errorPageTemplate", TEMPLATE_MUST_NOT_BE_EMPTY, null);
        }
        if (configurationData.loggedOutPageTemplate == null || configurationData.loggedOutPageTemplate.trim().isEmpty()) {
            result.add("loggedOutPageTemplate", TEMPLATE_MUST_NOT_BE_EMPTY, null);
        }
        if (configurationData.idpSelectionPageTemplate == null || configurationData.idpSelectionPageTemplate.trim().isEmpty()) {
            result.add("idpSelectionPageTemplate", TEMPLATE_MUST_NOT_BE_EMPTY, null);
        }
        if (configurationData.idpByEmailPageTemplate == null || configurationData.idpByEmailPageTemplate.trim().isEmpty()) {
            result.add("idpByEmailPageTemplate", TEMPLATE_MUST_NOT_BE_EMPTY, null);
        }
        if (configurationData.oidcJwksCacheSize < 0L) {
            result.add("oidcJwksCacheSize", "Cache size must be greater or equal than zero.");
        }
        if (configurationData.oidcJwksCacheExpiresInMinutes < 0L) {
            result.add("oidcJwksCacheExpiresInMinutes", "Cache validity must be greater or equal than zero.");
        }
        if (configurationData.commonMetadataCertificate != null && !configurationData.commonMetadataCertificate.isEmpty() && !(commonCertCheckResult = this.certUtil.check(configurationData.commonMetadataCertificate, null)).isValid()) {
            result.add("commonMetadataCertificate", "Certificate is not valid: " + commonCertCheckResult.getMessage());
        }
        if (configurationData.commonMetadataUrl != null && !configurationData.commonMetadataUrl.isEmpty() && (configurationData.commonMetadataCertificate == null || configurationData.commonMetadataCertificate.isEmpty())) {
            result.add("commonMetadataCertificate", null, "If no certificate is set, the common metadata cannot be validated.");
        }
        if (configurationData.acceptHolderOfKeyLikeBearer) {
            result.add("acceptHolderOfKeyLikeBearer", null, "Be aware that the SubjectConfirmation is handled as if it was bearer. No validation is performed for the cryptographic data contained in the SubjectConfirmation.");
        }
        HashSet<Integer> existingIdpIds = new HashSet<Integer>();
        if (configurationData.idpConfigurations == null || configurationData.idpConfigurations.isEmpty()) {
            result.add("idpConfigurations", null, "At least one Identity provider should be configured");
            if (configurationData.redirectToSso) {
                result.add("overrideLoginUrl", "Redirection cannot be enabled without at least one IdP", null);
            }
            if (configurationData.redirectServiceDeskPortals != ConfigurationData.RedirectServiceDeskPortals.NONE) {
                result.add("redirectServiceDeskPortals", "Service Desk Redirection cannot be enabled without at least one IdP", null);
            }
        } else {
            CommonIdpConfigurationData currentIdpConfig;
            int idpindex;
            ValidationResult idpsValidationResult = ValidationResult.create();
            result.add("idpConfigurations", idpsValidationResult);
            Map<Object, Object> names = new HashMap();
            Map<Object, Object> entityIDsOrIdpIds = new HashMap();
            Map<Object, Object> weights = new HashMap();
            Map<Object, Object> clientIds = new HashMap();
            for (idpindex = 0; idpindex < configurationData.idpConfigurations.size(); ++idpindex) {
                currentIdpConfig = configurationData.idpConfigurations.get(idpindex);
                this.createOrUpdateMapEntry(names, idpindex, currentIdpConfig.name);
                this.createOrUpdateMapEntry(entityIDsOrIdpIds, idpindex, currentIdpConfig.idpId);
                this.createOrUpdateMapEntry(weights, idpindex, currentIdpConfig.weight);
                if (!(currentIdpConfig instanceof OAuth2IdpConfigurationData)) continue;
                String currentClientId = ((OAuth2IdpConfigurationData)currentIdpConfig).clientId;
                this.createOrUpdateMapEntry(clientIds, idpindex, currentClientId);
            }
            names = names.entrySet().stream().filter(es -> ((Set)es.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            entityIDsOrIdpIds = entityIDsOrIdpIds.entrySet().stream().filter(es -> ((Set)es.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            weights = weights.entrySet().stream().filter(es -> ((Set)es.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            clientIds = clientIds.entrySet().stream().filter(es -> ((Set)es.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (idpindex = 0; idpindex < configurationData.idpConfigurations.size(); ++idpindex) {
                String currentClientId;
                ValidationResult currentIdpValidationResult;
                currentIdpConfig = configurationData.idpConfigurations.get(idpindex);
                if (currentIdpConfig.protocolType == ProtocolType.SAML) {
                    currentIdpValidationResult = this.samlIdpConfigurationValidator.validate((Object)((SamlIdpConfigurationData)currentIdpConfig), (Object)configurationData);
                } else if (currentIdpConfig.protocolType == ProtocolType.OIDC) {
                    currentIdpValidationResult = this.oidcIdpConfigurationValidator.validate((Object)((OidcIdpConfigurationData)currentIdpConfig), (Object)configurationData);
                } else if (currentIdpConfig.protocolType == ProtocolType.OAU2) {
                    currentIdpValidationResult = this.oAuth2IdpConfigurationDataConfigurationDataValidator.validate((Object)((OAuth2IdpConfigurationData)currentIdpConfig), (Object)configurationData);
                } else {
                    logger.error("Encountered a config type which does not exist {}", currentIdpConfig.getClass());
                    continue;
                }
                idpsValidationResult.add(idpindex, currentIdpValidationResult);
                if (currentIdpConfig instanceof OAuth2IdpConfigurationData && clientIds.containsKey(currentClientId = ((OAuth2IdpConfigurationData)currentIdpConfig).clientId) && ((Set)clientIds.get(currentClientId)).contains(idpindex)) {
                    currentIdpValidationResult.add("clientId", "Client ID must be unique", null);
                }
                if (names.containsKey(currentIdpConfig.name) && ((Set)names.get(currentIdpConfig.name)).contains(idpindex)) {
                    currentIdpValidationResult.add("name", "Name must be unique", null);
                }
                if (entityIDsOrIdpIds.containsKey(currentIdpConfig.idpId) && ((Set)entityIDsOrIdpIds.get(currentIdpConfig.idpId)).contains(idpindex)) {
                    currentIdpValidationResult.add(IDP_ID, "The EntityId/IdpId must be unique. You may see this message because you tried to import the same metadata twice!", null);
                }
                if (weights.containsKey(currentIdpConfig.weight) && ((Set)weights.get(currentIdpConfig.weight)).contains(idpindex)) {
                    currentIdpValidationResult.add("weight", "Weight must be unique", null);
                }
                if (existingIdpIds.contains(currentIdpConfig.id)) {
                    currentIdpValidationResult.add("id", "ID must be unique", null);
                    continue;
                }
                existingIdpIds.add(currentIdpConfig.id);
            }
        }
        if (configurationData.idpSelectionMethod == RunningConfiguration.IdpSelectionMethod.EMAIL) {
            ValidationResult emailDomainsForIdpSelectionResult = ValidationResult.create();
            result.add("emailDomainsForIdpSelection", emailDomainsForIdpSelectionResult);
            for (i = 0; i < configurationData.emailDomainsForIdpSelection.size(); ++i) {
                EmailDomainIdpId emailDomainIdpId = configurationData.emailDomainsForIdpSelection.get(i);
                ValidationResult emailDomainResult = ValidationResult.create();
                emailDomainsForIdpSelectionResult.add(i, emailDomainResult);
                if (emailDomainIdpId.emailDomain == null || emailDomainIdpId.emailDomain.equals("")) {
                    emailDomainResult.add(EMAIL_DOMAIN, null, "Empty email domain regex");
                } else {
                    try {
                        Pattern pattern = Pattern.compile("^.+\\..+[^\\.]$");
                        Matcher matcher = pattern.matcher(emailDomainIdpId.emailDomain);
                        if (matcher.find()) {
                            String[] emailDomainArray = emailDomainIdpId.emailDomain.split("\\.");
                            for (int j = 0; j < emailDomainArray.length - 1; ++j) {
                                if (emailDomainArray[j].endsWith("\\")) continue;
                                emailDomainResult.add(EMAIL_DOMAIN, null, "The backslash is necessary before dot to treat it as a dot and not as a wildcard character.");
                            }
                        } else {
                            emailDomainResult.add(EMAIL_DOMAIN, "The Email Domain is invalid, please read the instructions above", null);
                        }
                        Pattern.compile(emailDomainIdpId.emailDomain);
                    }
                    catch (PatternSyntaxException e) {
                        emailDomainResult.add(EMAIL_DOMAIN, e.getMessage(), null);
                    }
                }
                if (emailDomainIdpId.idpId != -1 && !existingIdpIds.contains(emailDomainIdpId.idpId)) {
                    emailDomainResult.add(IDP_ID, "Entry references non-existent or deleted IdP ID", null);
                }
                if (emailDomainIdpId.idpId != -1 || configurationData.nossoEnabled) continue;
                emailDomainResult.add(IDP_ID, "No SSO is not enabled", null);
            }
        }
        ValidationResult requestHeadersForIdpSelectionResult = ValidationResult.create();
        result.add("requestHeadersForIdpSelection", requestHeadersForIdpSelectionResult);
        for (i = 0; i < configurationData.requestHeadersForIdpSelection.size(); ++i) {
            HeaderValueIdpId requestHeaderIdpId = configurationData.requestHeadersForIdpSelection.get(i);
            ValidationResult requestHeaderResult = ValidationResult.create();
            requestHeadersForIdpSelectionResult.add(i, requestHeaderResult);
            if (requestHeaderIdpId.name == null || requestHeaderIdpId.name.equals("")) {
                requestHeaderResult.add("name", "Empty request header name", null);
            } else if (requestHeaderIdpId.value != null && !requestHeaderIdpId.value.equals("")) {
                try {
                    Pattern.compile(requestHeaderIdpId.value);
                }
                catch (PatternSyntaxException e) {
                    requestHeaderResult.add("value", e.getMessage(), null);
                }
            }
            if (requestHeaderIdpId.idpId != -1 && !existingIdpIds.contains(requestHeaderIdpId.idpId)) {
                requestHeaderResult.add(IDP_ID, "Entry references non-existent or deleted IdP ID", null);
            }
            if (requestHeaderIdpId.idpId != -1 || configurationData.nossoEnabled) continue;
            requestHeaderResult.add(IDP_ID, "No SSO is not enabled", null);
        }
        ValidationResult nonSsoDestinationsResult = ValidationResult.create();
        result.add("nonSsoDestinations", nonSsoDestinationsResult);
        for (int i2 = 0; i2 < configurationData.nonSsoDestinations.size(); ++i2) {
            String current = configurationData.nonSsoDestinations.get(i2);
            if (current != null && !current.trim().isEmpty()) continue;
            nonSsoDestinationsResult.add(i2, "URL must not be empty", null);
        }
        ValidationResult enforceSsoDestinationsResult = ValidationResult.create();
        result.add("enforceSsoDestinations", enforceSsoDestinationsResult);
        for (int i3 = 0; i3 < configurationData.enforceSsoDestinations.size(); ++i3) {
            String current = configurationData.enforceSsoDestinations.get(i3);
            if (current == null || current.trim().isEmpty()) {
                enforceSsoDestinationsResult.add(i3, "must not be empty", null);
                continue;
            }
            try {
                Pattern.compile(current);
                continue;
            }
            catch (Exception e) {
                enforceSsoDestinationsResult.add(i3, e.getMessage(), null);
            }
        }
        ValidationResult userAgentsResult = ValidationResult.create();
        result.add("nonSsoUserAgents", userAgentsResult);
        for (int i4 = 0; i4 < configurationData.nonSsoUserAgents.size(); ++i4) {
            String current = configurationData.nonSsoUserAgents.get(i4);
            if (current != null && !current.trim().isEmpty()) continue;
            userAgentsResult.add(i4, "User Agent must not be empty", null);
        }
        ValidationResult allowedNotificationEmailAddressesResult = ValidationResult.create();
        result.add("allowedNotificationEmailAddresses", allowedNotificationEmailAddressesResult);
        for (int i5 = 0; i5 < configurationData.allowedNotificationEmailAddresses.size(); ++i5) {
            String current = configurationData.allowedNotificationEmailAddresses.get(i5);
            if (current == null || current.trim().isEmpty()) {
                allowedNotificationEmailAddressesResult.add(i5, "Email Address must not be empty", null);
                continue;
            }
            try {
                InternetAddress internetAddress = new InternetAddress(current);
                internetAddress.validate();
                continue;
            }
            catch (Exception e) {
                allowedNotificationEmailAddressesResult.add(i5, "This is no valid email address", null);
            }
        }
        ValidationResult metadataInformation = ValidationResult.create();
        result.add("metadataInformation", metadataInformation);
        ValidationResult organization = ValidationResult.create();
        metadataInformation.add("organization", organization);
        this.checkLocalizedInputList(configurationData.getMetadataInformation().getOrganization().getNames(), organization, "names", "Organization name");
        this.checkLocalizedInputList(configurationData.getMetadataInformation().getOrganization().getDisplayNames(), organization, "displayNames", "Organization display name");
        this.checkLocalizedInputList(configurationData.getMetadataInformation().getOrganization().getUrls(), organization, "urls", "Organization URL");
        ValidationResult contacts = ValidationResult.create();
        metadataInformation.add("contacts", contacts);
        for (int i6 = 0; i6 < configurationData.metadataInformation.getContacts().size(); ++i6) {
            Contact contact = (Contact)configurationData.metadataInformation.getContacts().get(i6);
            ValidationResult currentContact = ValidationResult.create();
            contacts.add(i6, currentContact);
            if (contact.getFirstname() == null || contact.getFirstname().isEmpty()) {
                currentContact.add("firstname", "First name must not be empty", null);
            }
            if (contact.getLastname() == null || contact.getLastname().isEmpty()) {
                currentContact.add("lastname", "Last name must not be empty", null);
            }
            if (contact.getCompany() == null || contact.getCompany().isEmpty()) {
                currentContact.add("company", "Company must not be empty", null);
            }
            this.checkStringArrayForEmptyStrings(contact.getEmailAddresses(), currentContact, "emailAddresses", "Email address");
            this.checkStringArrayForEmptyStrings(contact.getTelephoneNumbers(), currentContact, "telephoneNumbers", "Phone number");
        }
        if (!configurationData.fetchFromRemoteDirectory) {
            result.add("fetchFromRemoteDirectory", null, "Users newly created or modified in remote directories could not be able to login if this is disabled");
        }
        if (configurationData.redirectServiceDeskPortals != ConfigurationData.RedirectServiceDeskPortals.NONE && configurationData.overrideLoggedOutUrlMethod == RunningConfiguration.OverrideLoggedOutUrlMethod.NO_REDIRECTION) {
            result.add("overrideLoggedOutUrlMethod", null, "Logout redirection should be set to 'Redirect all users after logout' or 'Redirect only SSO users after logout'. Otherwise users will be logged in again immediately after logging out.");
        }
        if (configurationData.redirectToSso && configurationData.overrideLoggedOutUrlMethod == RunningConfiguration.OverrideLoggedOutUrlMethod.NO_REDIRECTION) {
            result.add("overrideLoggedOutUrlMethod", null, "Logout redirection should be set to 'Redirect all users after logout' or 'Redirect only SSO users after logout'. Otherwise users will be logged in again immediately after logging out.");
        }
        if (this.logoutRedirectRecommendedWarningService.isWarning() && configurationData.redirectToSso && configurationData.idpSelectionMethod == RunningConfiguration.IdpSelectionMethod.FIRST && configurationData.overrideLoggedOutUrlMethod == RunningConfiguration.OverrideLoggedOutUrlMethod.NO_REDIRECTION) {
            result.add("overrideLoggedOutUrlMethod", null, "Users will be redirected to the IdP immediately after logout. If they have an active session on the IdP they will be logged in back to this application without further notice. If you don't want that please select another Logout Redirection option.");
        }
        if (this.logoutRedirectRecommendedWarningService.isWarning() && configurationData.redirectToSso && configurationData.idpSelectionMethod == RunningConfiguration.IdpSelectionMethod.FIRST && configurationData.overrideLoggedOutUrlMethod == RunningConfiguration.OverrideLoggedOutUrlMethod.REDIRECT_SSO_ONLY) {
            result.add("overrideLoggedOutUrlMethod", null, "Users logging in with username and password (nosso) will be redirected to the IdP immediately after logout. If they have an active session on the IdP they will be logged in back to this application without further notice. If you don't want that please select another Logout Redirection option.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug(result.toString());
        }
        if (CollectionUtil.isNullOrEmpty(configurationData.redirectCheckerBlockedStrings)) {
            result.add(REDIRECT_CHECKER_BLOCKED_STRINGS, null, "You have removed all of the defaults which may lower the security of your system.");
        } else {
            ValidationResult redirectCheckerBlockedStringsResult = ValidationResult.create();
            for (int i7 = 0; i7 < configurationData.redirectCheckerBlockedStrings.size(); ++i7) {
                String tmp = configurationData.redirectCheckerBlockedStrings.get(i7);
                if (tmp != null && !tmp.isEmpty()) continue;
                redirectCheckerBlockedStringsResult.add(i7, "You must either enter something or delete this entry");
            }
            if (!redirectCheckerBlockedStringsResult.isValid()) {
                result.add(REDIRECT_CHECKER_BLOCKED_STRINGS, redirectCheckerBlockedStringsResult);
            } else if (!new HashSet<String>(configurationData.redirectCheckerBlockedStrings).containsAll(Defaults.DEFAULT_ILLEGAL_REDIRECT_STRINGS)) {
                result.add(REDIRECT_CHECKER_BLOCKED_STRINGS, null, "You have removed some of the defaults which may lower the security of your system.");
            }
        }
        if (configurationData.hideLoginForm && configurationData.idpConfigurations.stream().noneMatch(idp -> idp.shouldDisplayIdpButtonOnLoginPage)) {
            result.add("hideLoginForm", "You cannot hide the login form when you do not display at least one idp button - otherwise you would not see anything for login!");
        }
        return result;
    }

    private <T> void createOrUpdateMapEntry(Map<T, Set<Integer>> map, int idpindex, T key) {
        if (map.containsKey(key)) {
            Set<Integer> tmp = map.get(key);
            tmp.add(idpindex);
            map.put(key, tmp);
        } else {
            map.put(key, new HashSet<Integer>(Collections.singletonList(idpindex)));
        }
    }

    private void checkLocalizedInputList(List<StringWithLang> list, ValidationResult parent, String fieldName, String fieldDisplayName) {
        ValidationResult validationResult = ValidationResult.create();
        parent.add(fieldName, validationResult);
        for (int i = 0; i < list.size(); ++i) {
            StringWithLang stringWithLang = list.get(i);
            ValidationResult currentInput = ValidationResult.create();
            validationResult.add(i, currentInput);
            if (stringWithLang.getValue() == null || stringWithLang.getValue().isEmpty()) {
                currentInput.add("value", fieldDisplayName + " must not be empty", null);
            }
            if (stringWithLang.getLang() != null && !stringWithLang.getLang().isEmpty()) continue;
            currentInput.add("lang", "Language must not be empty", null);
        }
    }

    private void checkStringArrayForEmptyStrings(List<String> list, ValidationResult parent, String fieldName, String fieldDisplayName) {
        ValidationResult validationResult = ValidationResult.create();
        parent.add(fieldName, validationResult);
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (string != null && !string.isEmpty()) continue;
            validationResult.add(i, fieldDisplayName + " must not be empty", null);
        }
    }
}

