/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.resolution.atlasplugins.samlsso.Defaults;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationMigrator {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationMigrator.class);
    public static final String DEFAULT_IDPNAME = "IDP";
    private PluginSettings pluginSettings;

    public abstract ConfigurationData migrateSpecific(ConfigurationData var1);

    public ConfigurationData migrate(PluginSettings pluginSettings, ConfigurationData configData) {
        String cert;
        String tpl;
        String agt;
        String logoutUrl;
        SamlIdpConfigurationData idpConfig;
        this.pluginSettings = pluginSettings;
        if (!this.has("idpUrl")) {
            logger.debug("idpUrl is not set, we have no old configuration to migrate.");
            return configData;
        }
        logger.info("Migrating Configuration...");
        if (configData.idpConfigurations.isEmpty()) {
            logger.info("Creating new IdP configuration");
            idpConfig = new SamlIdpConfigurationData();
            idpConfig.id = 1;
            configData.idpConfigurations.add(idpConfig);
        } else {
            logger.warn("There is already a Idp Configuration. This is not expected. Data will be overwritten.");
            idpConfig = (SamlIdpConfigurationData)configData.idpConfigurations.get(0);
        }
        if (idpConfig.name == null) {
            logger.info("Setting IdP name {}", (Object)DEFAULT_IDPNAME);
            idpConfig.name = DEFAULT_IDPNAME;
        }
        if (this.has("idpUrl")) {
            String idpUrl = this.get("idpUrl");
            logger.info("Setting first IdP URL to {}", (Object)idpUrl);
            idpConfig.postBindingURL = idpUrl;
        }
        if (this.has("relayStateParameterName")) {
            String rl = this.get("relayStateParameterName");
            if (!rl.equals("RelayState")) {
                logger.info("Setting default RelayState parameter name to {}", (Object)rl);
            }
            idpConfig.relayStateParameterName = rl;
        }
        if (this.has("useridTransformationRegex") && this.has("useridTransformationReplacement")) {
            String regex = this.get("useridTransformationRegex");
            logger.info("Setting useridTransformationRegex to {}", (Object)regex);
            String repl = this.get("useridTransformationReplacement");
            logger.info("Setting useridTransformationReplacement to {}", (Object)repl);
        }
        if (this.has("setLoginUrl")) {
            logger.info("Enabling login URL overide");
            configData.redirectToSso = true;
        }
        if (this.has("overrideLogOutURL")) {
            logger.info("Enabling logout URL overide");
        }
        if (this.has("enableUserForLogin")) {
            logger.info("Enabling login enablement for Service Desk users");
            configData.enableUserForLogin = true;
        }
        if (this.has("logoutUrl") && !(logoutUrl = this.get("logoutUrl")).equals("/plugins/servlet/samlsso/logout")) {
            logger.info("Setting logout URL to {}", (Object)logoutUrl);
            configData.logoutUrl = logoutUrl;
        }
        if (this.has("defaultRedirectUrl")) {
            String url = this.get("defaultRedirectUrl");
            if (!url.equals("/")) {
                logger.info("Setting default redirect URL to {}", (Object)url);
            }
            configData.defaultRedirectUrl = url;
        }
        if (this.has("groupsToAddUserTo")) {
            String groups = this.get("groupsToAddUserTo");
            logger.info("Setting groups to {}", (Object)groups);
            configData.groupsToAddUserTo = Utils.splitString(groups);
        }
        if (this.has("nonSsoUserAgents") && !(agt = this.get("nonSsoUserAgents")).equals("Jakarta Commons-HttpClient,ms-office,Microsoft Office")) {
            logger.info("Setting nonsso-useragents to {}", (Object)agt);
            configData.nonSsoUserAgents = Utils.splitString(agt);
        }
        if (this.has("nonSsoDestinations") && !(agt = this.get("nonSsoDestinations")).equals("/plugins/servlet/applinks,applicationlinks")) {
            logger.info("Setting nonsso-destinations to {}", (Object)agt);
            configData.nonSsoDestinations = Utils.splitString(agt);
        }
        if (this.has("errorPageTemplate") && !(tpl = this.get("errorPageTemplate")).equals(Defaults.DEFAULT_ERRORPAGETEMPLATE)) {
            logger.info("Setting error page template to {}", (Object)tpl);
            configData.errorPageTemplate = tpl;
        }
        if (this.has("loggedOutPageTemplate") && !(tpl = this.get("loggedOutPageTemplate")).equals(Defaults.DEFAULT_LOGGEDOUTPAGETEMPLATE)) {
            logger.info("Setting logged out page template to {}", (Object)tpl);
            configData.loggedOutPageTemplate = tpl;
        }
        if (this.has("base64encodedCertificate")) {
            cert = this.get("base64encodedCertificate");
            logger.info("Setting cetificate to {}", (Object)cert);
            idpConfig.certificates.add(cert);
        }
        if (!this.has("base64encodedCertificate") && this.has("base64encodedIdPCertificate")) {
            cert = this.get("base64encodedIdPCertificate");
            logger.info("Setting cetificate from key base64encodedIdPCertificate to {}", (Object)cert);
            idpConfig.certificates.add(cert);
        }
        return this.migrateSpecific(configData);
    }

    private boolean has(String key) {
        return this.pluginSettings.get(ConfigurationData.getPluginSettingsKey(key, false)) != null;
    }

    private String get(String key) {
        return (String)this.pluginSettings.get(ConfigurationData.getPluginSettingsKey(key, false));
    }
}

