/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.LogoutHandler;
import com.resolution.samlwrapper.api.exception.LogoutHandlerException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogoutHander
implements LogoutHandler {
    protected final SamlSsoService samlSsoService;
    protected final RunningConfiguration pluginConfiguration;
    private static final Logger customLoginLogger = LoggerFactory.getLogger((String)"com.resolution.atlasplugins.samlsso.userauth.CustomLoginLogger");

    protected AbstractLogoutHander(@Nonnull SamlSsoService samlSsoService, @Nonnull RunningConfiguration pluginConfiguration) {
        this.samlSsoService = samlSsoService;
        this.pluginConfiguration = pluginConfiguration;
    }

    protected abstract void doLogout(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nonnull AuthenticationTracker var3) throws LogoutHandlerException, IOException;

    public void logout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull SAMLAuthenticationTracker tracker) throws LogoutHandlerException, IOException {
        if (customLoginLogger.isDebugEnabled()) {
            customLoginLogger.debug("Triggering SSO logout for user: {} tracker={}", (Object)tracker.getUserId(), (Object)tracker.getTrackerId());
        }
        this.doLogout(req, resp, (AuthenticationTracker)tracker);
    }

    public void showLoggedOutPage(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull SAMLAuthenticationTracker tracker) throws ServletException, IOException {
        String logoutUrl = this.pluginConfiguration.getLogoutUrl();
        if (logoutUrl != null && !logoutUrl.trim().isEmpty()) {
            resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            resp.sendRedirect(logoutUrl);
            return;
        }
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.sendRedirect(this.samlSsoService.getRelativeLoggedOutPageUrl() + "?t=" + tracker.getTrackerId());
    }

    public boolean isLoggedInUser(@Nonnull HttpServletRequest request) {
        return this.samlSsoService.isLoggedInUser(request);
    }
}

