/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.userauth;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.resolution.atlasplugins.samlsso.userauth.AbstractRemoteDirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.RemoteDirectoryAdapter;
import java.security.Principal;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@ExportAsService(value={RemoteDirectoryAdapter.class})
public class JiraRemoteDirectoryAdapter
extends AbstractRemoteDirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JiraRemoteDirectoryAdapter.class);
    private final LoginService loginService;

    @Inject
    public JiraRemoteDirectoryAdapter(@JiraImport DirectoryInstanceLoader directoryInstanceLoader, @JiraImport CrowdService crowdService, @JiraImport LoginService loginService) {
        super(directoryInstanceLoader, crowdService);
        this.loginService = loginService;
    }

    @Override
    protected boolean isFirstLogin(@Nullable Principal principal) {
        if (principal == null) {
            logger.debug("Principal is null, returning false.");
            return false;
        }
        LoginInfo loginInfo = this.loginService.getLoginInfo(principal.getName());
        if (loginInfo == null) {
            logger.debug("LoginInfo is null for principal: {}, returning false.", (Object)principal.getName());
            return false;
        }
        Long loginCount = loginInfo.getLoginCount();
        logger.debug("Login count for principal {}: {}", (Object)principal.getName(), (Object)loginCount);
        return loginCount == null || loginCount == 0L;
    }
}

