/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicListener;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.resolution.atlasplugins.samlsso.cluster.AbstractClusterNotificator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class BitbucketClusterNotificator
extends AbstractClusterNotificator
implements TopicListener<String> {
    public static final String TOPIC = "SamlSsoChannel";
    public static final TopicSettings<String> TOPIC_SETTINGS = TopicSettings.builder(String.class).dedupePendingMessages(true).build();
    private final TopicService topicService;
    private final Topic<String> topic;
    private final String myNodeId;
    public static final Logger logger = LoggerFactory.getLogger(BitbucketClusterNotificator.class);

    @Inject
    public BitbucketClusterNotificator(@BitbucketImport TopicService topicService, @BitbucketImport ClusterService clusterService) {
        logger.debug("our cluster id is {} ", (Object)clusterService.getNodeId());
        this.myNodeId = clusterService.getNodeId();
        this.topicService = topicService;
        this.topic = topicService.getTopic(TOPIC, TOPIC_SETTINGS);
        this.topic.subscribe((TopicListener)this);
    }

    @Override
    public void send(String message) {
        logger.debug("Sending message {}", (Object)message);
        this.topic.publish((Serializable)((Object)message));
    }

    public void onMessage(@Nonnull MessageEvent<String> messageEvent) {
        if (!messageEvent.getSource().isLocal()) {
            logger.debug("Node ID " + this.myNodeId + " Received message " + (String)messageEvent.getMessage() + " from " + messageEvent.getSource() + " over channel " + messageEvent.getTopic());
            if (messageEvent.getTopic().equals(TOPIC)) {
                super.notifiyListeners((String)messageEvent.getMessage());
            }
        } else {
            logger.debug("Ignoring message {} from local node", messageEvent.getMessage());
        }
    }
}

