/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.commons.util.Elvis;
import de.resolution.usersync.spi.AbstractConnectorConfigurationImpl;
import de.resolution.usersync.spi.HTTPConnectorConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.logging.HttpLoggingInterceptor;

public abstract class AbstractHTTPConnectorConfigurationImpl
extends AbstractConnectorConfigurationImpl
implements HTTPConnectorConfiguration {
    private int connectTimeout = 20;
    private int readTimeout = 20;
    @Nonnull
    private HttpLoggingInterceptor.Level httpLogLevel = HttpLoggingInterceptor.Level.NONE;
    private int maxRetries = 5;

    protected AbstractHTTPConnectorConfigurationImpl() {
    }

    protected AbstractHTTPConnectorConfigurationImpl(HTTPConnectorConfiguration other) {
        super(other);
        this.setConnectTimeout(other.getConnectTimeout());
        this.setReadTimeout(other.getReadTimeout());
        this.setHttpLogLevel(other.getHttpLogLevel());
        this.setMaxRetries(other.getMaxRetries());
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    @Nonnull
    public HttpLoggingInterceptor.Level getHttpLogLevel() {
        return this.httpLogLevel;
    }

    public void setHttpLogLevel(@Nullable HttpLoggingInterceptor.Level httpLogLevel) {
        this.httpLogLevel = (HttpLoggingInterceptor.Level)Elvis.ifNull((Object)httpLogLevel, (Object)HttpLoggingInterceptor.Level.NONE);
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }
}

