/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.commons.task.api.Task;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncUserResult;
import de.resolution.usersync.api.SyncUserResultRepository;
import de.resolution.usersync.heartbeat.HeartbeatSender;
import de.resolution.usersync.impl.AoSyncStatus;
import de.resolution.usersync.impl.AoSyncStatusAttributes;
import de.resolution.usersync.impl.AoSyncStatusMessage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
public class SyncStatusAoProxy
implements SyncStatus {
    private static final Logger logger = LoggerFactory.getLogger(SyncStatusAoProxy.class);
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    private final ActiveObjects ao;
    private final SyncUserResultRepository syncUserResultRepository;
    private final HeartbeatSender heartbeatSender;
    private final int id;
    private boolean simulate;
    private boolean scheduled;

    SyncStatusAoProxy(@Nonnull ActiveObjects ao, @Nonnull SyncUserResultRepository syncUserResultRepository, int id, @Nonnull HeartbeatSender heartbeatSender) {
        this.ao = ao;
        this.syncUserResultRepository = syncUserResultRepository;
        this.heartbeatSender = heartbeatSender;
        this.id = id;
        this.loadFinalAttributes();
    }

    private void loadFinalAttributes() {
        this.ao.executeInTransaction(() -> {
            AoSyncStatusAttributes attr = (AoSyncStatusAttributes)this.ao.get(AoSyncStatusAttributes.class, (Object)this.id);
            if (attr == null) {
                this.simulate = false;
                this.scheduled = false;
            } else {
                this.simulate = attr.isSimulate();
                this.scheduled = attr.isScheduled();
            }
            return null;
        });
    }

    @Override
    public boolean isActive() {
        return this.getStatus() == Task.Status.NEW || this.getStatus() == Task.Status.RUNNING || this.getStatus() == Task.Status.CANCELLING;
    }

    @Override
    public void setStatus(Task.Status status) {
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            aoSyncStatus.setStatus(status.toString());
            aoSyncStatus.setLastModifiedTime(new Date().getTime());
            aoSyncStatus.save();
            return null;
        });
    }

    @Override
    public SyncStatus.Result getSyncStatusResult() {
        String resultString = this.getAoSyncStatus().getResult();
        return SyncStatus.Result.valueOf(resultString);
    }

    @Override
    public Task.Status getStatus() {
        String statusString = this.getAoSyncStatus().getStatus();
        return Task.Status.valueOf((String)statusString);
    }

    @Override
    public String getStatusMessage() {
        return this.getAoSyncStatus().getStatusMsg();
    }

    @Override
    public void setStatusMessage(String msg) {
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            aoSyncStatus.setStatusMsg(msg);
            aoSyncStatus.setLastModifiedTime(new Date().getTime());
            aoSyncStatus.save();
            return null;
        });
    }

    @Override
    public void setSyncStatusResult(SyncStatus.Result result) {
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            aoSyncStatus.setResult(result.toString());
            aoSyncStatus.setLastModifiedTime(new Date().getTime());
            aoSyncStatus.save();
            logger.debug("Set result in {} to {}", (Object)aoSyncStatus.getID(), (Object)result);
            return null;
        });
    }

    @Override
    public String getClusterNode() {
        return this.getAoSyncStatus().getClusterNode();
    }

    @Override
    public List<String> getMessages() {
        return (List)this.ao.executeInTransaction(() -> {
            Query msgQuery = Query.select().where("AO_SYNC_STATUS_ID = ?", new Object[]{this.id}).order("ID ASC");
            AoSyncStatusMessage[] aoSyncStatusMessages = (AoSyncStatusMessage[])this.ao.find(AoSyncStatusMessage.class, msgQuery);
            ArrayList<String> msg = new ArrayList<String>();
            for (AoSyncStatusMessage aoSyncStatusMessage : aoSyncStatusMessages) {
                msg.add(aoSyncStatusMessage.getMessage());
            }
            return msg;
        });
    }

    @Override
    public void addMessage(@Nonnull String message) {
        if (StringUtil.isNullOrEmpty((String)message)) {
            logger.debug("Tried to add a null or empty message to the sync status messages.");
            return;
        }
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            AoSyncStatusMessage msg = (AoSyncStatusMessage)this.ao.create(AoSyncStatusMessage.class, new DBParam[]{new DBParam("MESSAGE", (Object)message)});
            msg.setAoSyncStatus(aoSyncStatus);
            msg.save();
            aoSyncStatus.setLastModifiedTime(new Date().getTime());
            aoSyncStatus.save();
            logger.debug("Added message {} to {}", (Object)message, (Object)aoSyncStatus.getID());
            return null;
        });
    }

    @Override
    public void clearStatusMessage() {
        this.setStatusMessage("");
    }

    @Override
    public String getConnectorUID() {
        return this.getAoSyncStatus().getConnUID();
    }

    @Override
    public int getId() {
        return this.getAoSyncStatus().getID();
    }

    @Override
    public String getCreated() {
        return this.dateFormat.format(new Date(this.getAoSyncStatus().getCreatedTime()));
    }

    @Override
    public long getCreatedTime() {
        return this.getAoSyncStatus().getCreatedTime();
    }

    @Override
    public String getLastModified() {
        return this.dateFormat.format(new Date(this.getAoSyncStatus().getLastModifiedTime()));
    }

    @Override
    public long getDuration() {
        AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
        if (this.getStatus() == Task.Status.LISTENING) {
            return (new Date().getTime() - aoSyncStatus.getCreatedTime()) / 1000L;
        }
        return (aoSyncStatus.getLastModifiedTime() - aoSyncStatus.getCreatedTime()) / 1000L;
    }

    public int getAddedCount() {
        return this.getAoSyncStatus().getAdded();
    }

    public int getUpdatedCount() {
        return this.getAoSyncStatus().getUpdated();
    }

    public int getDeletedCount() {
        return this.getAoSyncStatus().getDeleted();
    }

    public int getNotModifiedCount() {
        return this.getAoSyncStatus().getNotModified();
    }

    public int getFailedCount() {
        return this.getAoSyncStatus().getFailed();
    }

    @Override
    public boolean isSimulate() {
        return this.simulate;
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    public void addFiltered() {
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            aoSyncStatus.setFiltered(aoSyncStatus.getFiltered() + 1);
            aoSyncStatus.setLastModifiedTime(new Date().getTime());
            aoSyncStatus.save();
            return null;
        });
    }

    public int getFilteredCount() {
        return this.getAoSyncStatus().getFiltered();
    }

    @Override
    public String getResultFilePath() {
        return this.getAoSyncStatus().getResultFilePath();
    }

    @Override
    public void setResultFilePath(String resultFilePath) {
        logger.info("setResultFilePath is not supported yet");
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            aoSyncStatus.setResultFilePath(resultFilePath);
            aoSyncStatus.setLastModifiedTime(new Date().getTime());
            aoSyncStatus.save();
            logger.debug("Set resultFilePath in {} to {}", (Object)aoSyncStatus.getID(), (Object)resultFilePath);
            return null;
        });
    }

    public void add(AtlasUserResult atlasUserResult) {
        this.add(SyncUserResult.create(null, atlasUserResult));
    }

    @Override
    public void add(SyncUserResult result) {
        this.ao.executeInTransaction(() -> {
            AoSyncStatus aoSyncStatus = this.getAoSyncStatus();
            aoSyncStatus.setLastModifiedTime(System.currentTimeMillis());
            if (result.isSuccess()) {
                switch (result.getOperation()) {
                    case ADDED: {
                        aoSyncStatus.setAdded(aoSyncStatus.getAdded() + 1);
                        break;
                    }
                    case NOT_MODIFIED: {
                        aoSyncStatus.setNotModified(aoSyncStatus.getNotModified() + 1);
                        break;
                    }
                    case DELETED: {
                        aoSyncStatus.setDeleted(aoSyncStatus.getDeleted() + 1);
                        break;
                    }
                    case UPDATED: {
                        aoSyncStatus.setUpdated(aoSyncStatus.getUpdated() + 1);
                        break;
                    }
                    case FILTERED: {
                        aoSyncStatus.setFiltered(aoSyncStatus.getFiltered() + 1);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    case FAILED: {
                        aoSyncStatus.setFailed(aoSyncStatus.getFailed() + 1);
                        aoSyncStatus.setResult(SyncStatus.Result.PARTIALLY_FAILED.name());
                        break;
                    }
                }
            } else {
                aoSyncStatus.setFailed(aoSyncStatus.getFailed() + 1);
                aoSyncStatus.setResult(SyncStatus.Result.PARTIALLY_FAILED.name());
                AtlasUserResult atlasUserResult = result.getAtlasUserResult();
                if (atlasUserResult != null && atlasUserResult.getMessages().isPresent()) {
                    for (String message : (List)atlasUserResult.getMessages().get()) {
                        this.addMessage(message);
                    }
                }
            }
            this.syncUserResultRepository.storeSyncUserResult(result, aoSyncStatus.getID());
            aoSyncStatus.save();
            return null;
        });
    }

    public int getResultCount() {
        return this.syncUserResultRepository.countUserSyncResults(this.getAoSyncStatus().getID());
    }

    private AoSyncStatus getAoSyncStatus() {
        return (AoSyncStatus)this.ao.executeInTransaction(() -> {
            AoSyncStatus syncStatus = (AoSyncStatus)this.ao.get(AoSyncStatus.class, (Object)this.id);
            if (syncStatus != null) {
                return syncStatus;
            }
            throw new NotFoundException(this.id);
        });
    }

    @Override
    public void sendHeartbeat() {
        this.heartbeatSender.sendHeartbeat(this);
    }

    public static class NotFoundException
    extends RuntimeException {
        public NotFoundException(int id) {
            super("No SyncStatus found under id " + id);
        }
    }
}

