/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.heartbeat.HeartbeatReceiver;
import de.resolution.usersync.heartbeat.LocalHeartbeatSender;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

@ConfluenceComponent
public class ConfluenceHeartbeatSender
extends LocalHeartbeatSender {
    private final EventPublisher eventPublisher;

    @Inject
    public ConfluenceHeartbeatSender(HeartbeatReceiver heartbeatReceiver, @ConfluenceImport EventPublisher eventPublisher) {
        super(heartbeatReceiver);
        this.eventPublisher = eventPublisher;
    }

    @Override
    public long sendHeartbeat(@Nonnull SyncStatus syncStatus) {
        long timestamp = super.sendHeartbeat(syncStatus);
        String message = LocalHeartbeatSender.createMessage(syncStatus.getId(), timestamp);
        HeartbeatEvent heartbeatEvent = new HeartbeatEvent(this, message);
        this.eventPublisher.publish((Object)heartbeatEvent);
        return timestamp;
    }

    public static class HeartbeatEvent
    extends ConfluenceEvent
    implements ClusterEvent {
        private final String message;

        public HeartbeatEvent(@Nonnull Object source, @Nonnull String message) {
            super(source);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HeartbeatEvent that = (HeartbeatEvent)((Object)o);
            return Objects.equals(this.getMessage(), that.getMessage());
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getMessage());
        }
    }
}

