/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import de.resolution.usersync.heartbeat.ConfluenceHeartbeatSender;
import de.resolution.usersync.heartbeat.LocalHeartbeatReceiver;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@ConfluenceComponent
public class ConfluenceHeartbeatReceiver
extends LocalHeartbeatReceiver
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceHeartbeatReceiver.class);
    private final EventPublisher eventPublisher;

    public ConfluenceHeartbeatReceiver(@ConfluenceImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void handleRemoteEvent(@Nonnull ClusterEventWrapper wrapper) {
        try {
            ConfluenceHeartbeatSender.HeartbeatEvent event;
            LocalHeartbeatReceiver.IdAndTimestamp idAndTimestamp;
            Object eventObject = ClusterEventWrapper.class.getMethod("getEvent", new Class[0]).invoke((Object)wrapper, new Object[0]);
            if (eventObject instanceof ConfluenceHeartbeatSender.HeartbeatEvent && (idAndTimestamp = LocalHeartbeatReceiver.splitMessage((event = (ConfluenceHeartbeatSender.HeartbeatEvent)((Object)eventObject)).getMessage())) != null) {
                this.addHeartbeat(idAndTimestamp.getId(), idAndTimestamp.getTimestamp());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Failed to get event from ClusterEventWrapper", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

