/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.heartbeat;

import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.heartbeat.HeartbeatReceiver;
import de.resolution.usersync.heartbeat.LocalHeartbeatSender;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.inject.Inject;

@BitbucketComponent
public class BitbucketHeartbeatSender
extends LocalHeartbeatSender {
    private final Topic<String> topic;
    public static final TopicSettings<String> TOPIC_SETTINGS = TopicSettings.builder(String.class).dedupePendingMessages(true).build();

    @Inject
    public BitbucketHeartbeatSender(HeartbeatReceiver heartbeatReceiver, @BitbucketImport TopicService topicService) {
        super(heartbeatReceiver);
        this.topic = topicService.getTopic("usersync.heartbeat", TOPIC_SETTINGS);
    }

    @Override
    public long sendHeartbeat(@Nonnull SyncStatus syncStatus) {
        long timestamp = super.sendHeartbeat(syncStatus);
        String message = LocalHeartbeatSender.createMessage(syncStatus.getId(), timestamp);
        this.topic.publish((Serializable)((Object)message));
        return timestamp;
    }
}

