/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.jit;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.builtin.jit.JitConnectorConfiguration;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractConnector;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JitConnector
extends AbstractConnector<JitConnectorConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(JitConnector.class);

    protected JitConnector(@Nonnull ConnectorService connectorService, @Nonnull JitConnectorConfiguration configuration, @Nonnull AtlasUserAdapter atlasUserAdapter, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/JitConnector.json");
    }

    @Override
    @Nonnull
    protected FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        return FindUserResult.found((StructuredData)additionalData);
    }

    @Override
    @Nonnull
    public Class<JitConnectorConfiguration> getConfigurationClass() {
        return JitConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return "Just-in-Time";
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    @Override
    public boolean isCleanupConfigurable() {
        return false;
    }

    @Override
    public boolean isCanCopyUsers() {
        return false;
    }

    @Override
    public boolean isSelectableDirectory() {
        return true;
    }

    @Override
    public boolean isIncludeAllDirectories() {
        return true;
    }

    @Override
    public boolean isCanHaveRequiredGroups() {
        return false;
    }

    @Override
    public boolean isCanSync() {
        return false;
    }

    @Override
    public boolean isCanGenerateSyncResult() {
        return false;
    }

    @Override
    public boolean isCanBeScheduled() {
        return false;
    }

    @Override
    protected void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        syncStatusFacade.fail("Sync is not supported in this connector", logger);
    }
}

