/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.commons.license.PluginProperties;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.ExceptionEntity;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.Utils;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.analytics.ConfigAnalyticsPayload;
import de.resolution.reconfigure.api.AnalyticsProvider;
import de.resolution.reconfigure.api.ApplicationInformationProvider;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationFailedException;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.api.FrontendDTO;
import de.resolution.reconfigure.api.PluginInformationProvider;
import de.resolution.reconfigure.api.SystemInformationApplicationProvider;
import de.resolution.reconfigure.api.SystemInformationProvider;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/reconfigure")
@Named(value="configurationRestResource")
public class ConfigurationRestResource<C extends Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationRestResource.class);
    private final ConfigurationService<C> configurationService;
    private final AnalyticsProvider analyticsProvider;
    private final PrivilegeChecker privilegeChecker;
    private final ObjectMapper objectMapper;
    private final ApplicationInformationProvider applicationInformationProvider;
    private final PluginInformationProvider pluginInformationProvider;
    private final SystemInformationProvider systemInformationProvider;
    private final SystemInformationApplicationProvider systemInformationApplicationProvider;

    @Inject
    public ConfigurationRestResource(ConfigurationService<C> configurationService, AnalyticsProvider analyticsProvider, PrivilegeChecker privilegeChecker, ApplicationInformationProvider applicationInformationProvider, PluginInformationProvider pluginInformationProvider, SystemInformationProvider systemInformationProvider, SystemInformationApplicationProvider systemInformationApplicationProvider) {
        this.configurationService = configurationService;
        this.analyticsProvider = analyticsProvider;
        this.privilegeChecker = privilegeChecker;
        this.objectMapper = Utils.getObjectMapper();
        this.applicationInformationProvider = applicationInformationProvider;
        this.pluginInformationProvider = pluginInformationProvider;
        this.systemInformationProvider = systemInformationProvider;
        this.systemInformationApplicationProvider = systemInformationApplicationProvider;
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/frontenddefinitionfragment/{uiPath}/{identifier}")
    @ReadOnlyAccessAllowed
    public Response loadFrontendDefinitionFragment(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath, @PathParam(value="identifier") String identifier) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        Optional<String> fragmentOpt = this.configurationService.getFrontendDefinitionFragment(uiPath, identifier);
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        if (fragmentOpt.isPresent()) {
            logger.debug("Loading frontendDTO fragment successful");
            return Response.ok().cacheControl(Utils.CC_NO_CACHE).entity((Object)fragmentOpt.get()).build();
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Loading frontendDTO fragment failed. Fragment {} not found", (Object)identifier.replaceAll("[\n|\r|\t]", "_"));
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/frontenddto/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response loadFrontendDto(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        try {
            FrontendDTO<C> frontendDTO = this.configurationService.getFrontendDTO(request, userProfile, uiPath);
            this.objectMapper.addMixIn(frontendDTO.getConfig().getClass(), IncludeNullMixin.class);
            Response response = Response.ok().entity((Object)this.objectMapper.writeValueAsString(frontendDTO)).cacheControl(Utils.CC_NO_CACHE).build();
            logger.debug("Loading frontendDTO successful");
            return response;
        }
        catch (ConfigurationFailedException | IOException e) {
            logger.warn("Loading frontendDTO failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/validate/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response validate(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath, @QueryParam(value="useBase64") boolean useBase64, String jsonString) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        C config;
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.VALIDATE, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.VALIDATE, request, userProfile, uiPath), request, null);
        try {
            String decoded = jsonString;
            if (useBase64) {
                decoded = this.parseBase64(jsonString);
            }
            config = this.parse(decoded, uiPath);
            logger.debug("Parsing configuration successful");
        }
        catch (Exception e) {
            logger.warn("Parsing configuration failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
        try {
            Response response = Response.ok().entity((Object)this.objectMapper.writeValueAsString((Object)this.configurationService.validate(config, uiPath))).cacheControl(Utils.CC_NO_CACHE).build();
            logger.debug("Validating configuration successful");
            return response;
        }
        catch (Exception e) {
            logger.warn("Validating configuration failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @POST
    @Path(value="/validate/{uiPath}/{frontendStatePath}")
    @ReadOnlyAccessAllowed
    public Response validate(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath, @PathParam(value="frontendStatePath") String frontendStatePath, @QueryParam(value="useBase64") boolean useBase64, String jsonString) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.VALIDATE, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.VALIDATE, request, userProfile, uiPath), request, null);
        try {
            ValidationResult validationResult;
            String decoded = jsonString;
            if (useBase64) {
                decoded = this.parseBase64(jsonString);
            }
            if ((validationResult = this.configurationService.validateFrontendStateFragment(decoded, uiPath, frontendStatePath)) != null) {
                logger.debug("Validation Successful");
                return Response.ok().entity((Object)this.objectMapper.writeValueAsString((Object)validationResult)).cacheControl(Utils.CC_NO_CACHE).build();
            }
            logger.warn("Validation returned null");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Validation returned null").build();
        }
        catch (Exception e) {
            logger.warn("Validating configuration failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response loadConfiguration(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        try {
            C configuration = this.configurationService.getConfiguration(request, userProfile, uiPath);
            this.objectMapper.addMixIn(configuration.getClass(), IncludeNullMixin.class);
            Response response = Response.ok().entity((Object)this.objectMapper.writeValueAsString(configuration)).cacheControl(Utils.CC_NO_CACHE).build();
            logger.debug("Loading configuration successful");
            return response;
        }
        catch (ConfigurationFailedException | IOException e) {
            logger.warn("Loading configuration failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    @Consumes(value={"application/json"})
    @PUT
    @Path(value="/config/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response update(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath, @QueryParam(value="useBase64") boolean useBase64, String jsonString) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        C config;
        C sentConfig;
        PrivilegeChecker.AccessMode accessMode = PrivilegeChecker.AccessMode.WRITE;
        if (this.applicationInformationProvider.getMutableApplicationInformation().isReadOnlyMode()) {
            accessMode = PrivilegeChecker.AccessMode.WRITE_IN_READ_ONLY_MODE;
        }
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), accessMode, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(accessMode, request, userProfile, uiPath), request, null);
        try {
            String decoded = jsonString;
            if (useBase64) {
                decoded = this.parseBase64(jsonString);
            }
            sentConfig = this.parse(decoded, uiPath);
            logger.debug("Parsing configuration successful");
        }
        catch (IOException e) {
            logger.warn("Parsing configuration failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
        ValidationResult validationResult = this.configurationService.validate(sentConfig, uiPath);
        if (!validationResult.isValid()) {
            try {
                logger.debug("Response is valid");
                return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)this.objectMapper.writeValueAsString((Object)validationResult)).build();
            }
            catch (IOException e) {
                logger.warn("Sending validation error failed", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
            }
        }
        try {
            config = this.configurationService.update(sentConfig, validationResult, uiPath, userProfile);
            logger.debug("Updating successful");
        }
        catch (Exception e) {
            logger.warn("Updating configuration failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
        if (config != sentConfig) {
            validationResult = this.configurationService.validate(config, uiPath);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("validationResult", validationResult);
        resultMap.put("config", config);
        try {
            Response response = Response.ok().entity((Object)this.objectMapper.writeValueAsString(resultMap)).cacheControl(Utils.CC_NO_CACHE).build();
            logger.debug("Sending result successful");
            return response;
        }
        catch (Exception e) {
            logger.warn("Sending result failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/heartbeat/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response getHeartbeat(@Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        Optional<String> frontendDefinition;
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("appBuildTimestamp", PluginProperties.get((String)"buildTimestamp"));
        retVal.put("mutableApplicationInformation", this.applicationInformationProvider.getMutableApplicationInformation());
        if (PluginProperties.get((String)"frontendDefinitionPath") != null && (frontendDefinition = this.configurationService.getFrontendDefinition(uiPath)).isPresent()) {
            retVal.put("frontendDefinitionHashcode", Integer.toString(frontendDefinition.hashCode()));
        }
        return Response.ok((Object)Utils.toJson(retVal)).cacheControl(Utils.CC_NO_CACHE).build();
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="supportinformation/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response getSupportInformation(@Context HttpServletRequest request, @QueryParam(value="idList") List<String> idList, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        logger.debug("Request to access support information received. Checking privilege.");
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ_PRIVILEGED, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ_PRIVILEGED, request, userProfile, uiPath), request, null);
        logger.debug("Privilege check successful. Fetching support information.");
        try {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("appInfo", this.applicationInformationProvider.getApplicationInformation(request.getServletPath(), true));
            info.put("pluginInfo", this.pluginInformationProvider.getPluginInformation(request));
            info.put("systemInfo", this.systemInformationProvider.getSystemInformation());
            info.put("systemInfoApplication", this.systemInformationApplicationProvider.getSystemInformationApplication());
            Map<String, Object> supportInfo = this.configurationService.getSupportInformation(request, userProfile, uiPath, info, idList);
            if (supportInfo == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(Utils.CC_NO_CACHE).build();
            }
            logger.debug("Creating support information successful");
            return Utils.toOkResponse(supportInfo);
        }
        catch (Exception e) {
            logger.warn("Creating support information failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="improvementData/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response getAnalyticsPayload(@Context HttpServletRequest request, @QueryParam(value="previewConsentLevel") Integer previewConsentLevel, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        logger.debug("Request to access analytics information received. Checking privilege.");
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ_ANALYTICS, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ_ANALYTICS, request, userProfile, uiPath), request, null);
        logger.debug("Privilege check successful. Fetching data for analytics.");
        try {
            Optional<ConfigAnalyticsPayload> analyticsPayload = this.analyticsProvider.getAnalyticsPayload(previewConsentLevel);
            if (!analyticsPayload.isPresent()) {
                logger.debug("Analytics consent not given. Returning empty data.");
                if (previewConsentLevel != null) {
                    return Utils.toOkResponse("No analytics sent");
                }
                return Utils.toOkResponse(null);
            }
            logger.debug("Returning analytics bundle");
            return Utils.toOkResponse(analyticsPayload.get());
        }
        catch (Exception e) {
            logger.warn("Creating analytics payload for frontend failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ExceptionEntity(e).asJson()).build();
        }
    }

    private C parse(String jsonString, String uiPath) throws IOException {
        Class<C> configurationClass = this.configurationService.getConfigurationClass(uiPath);
        return (C)((Configuration)this.objectMapper.readValue(jsonString, configurationClass));
    }

    private String parseBase64(String encoded) throws IOException {
        String ENCODED_CONFIG = "encoded_config";
        JsonNode node = (JsonNode)new ObjectMapper().readValue(encoded, JsonNode.class);
        if (node.has("encoded_config")) {
            return new String(Base64.getDecoder().decode(node.get("encoded_config").asText()));
        }
        return encoded;
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private static interface IncludeNullMixin {
    }
}

