/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.resolution.atlasplugins.samlsso.userauth.SamlUserMigrator;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public abstract class AbstractSamlUserMigrator
implements SamlUserMigrator {
    private final AtlasUserAdapter atlasUserAdapter;

    @Inject
    public AbstractSamlUserMigrator(AtlasUserAdapter atlasUserAdapter) {
        this.atlasUserAdapter = atlasUserAdapter;
    }

    @Override
    public boolean isCrowdSamlUser(@Nonnull String userid) {
        Optional attributeValue;
        AtlasUserReference reference = AtlasUserReference.create((String)"ATTR_NAME", (Object)userid, (long)-1L);
        AtlasUserResult atlasUserResult = this.atlasUserAdapter.readFirstUniqueUser(reference);
        Optional resultingUser = atlasUserResult.getResultingUser();
        if (resultingUser.isPresent() && (attributeValue = ((AtlasUser)resultingUser.get()).get("CREATED_BY_SAML")).isPresent()) {
            return ((String)attributeValue.get()).equals("true");
        }
        return false;
    }

    @Override
    public boolean migrateToCrowdAttribute(@Nonnull String userid) {
        AtlasUserReference reference = AtlasUserReference.create((String)"ATTR_NAME", (Object)userid, (long)-1L);
        AtlasUser atlasUser = AtlasUser.builder().findBy(reference).with("CREATED_BY_SAML", new Object[]{"true"}).build();
        AtlasUserResult update = this.atlasUserAdapter.update(atlasUser);
        return update.getOperation() != AtlasUserResult.Operation.FAILED;
    }
}

