/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.atlassian.crowd.directory.DbCachingRemoteDirectory;
import com.atlassian.crowd.directory.DelegatedAuthenticationDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AbstractDirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.RemoteDirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.SyncRequiredException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteDirectoryAdapter
implements RemoteDirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRemoteDirectoryAdapter.class);
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final CrowdService crowdService;
    private final OkHttpClient okHttpClient;
    private static final int REQUEST_TIMEOUT = 30;
    private static final String PATH_TO_CROWD_NOTIFY = "rest/usermanagement/1/authentication/notify";
    public static final String AUTO_ADD_GROUPS_DIRECTORY_ATTRIBUTE = "autoAddGroups";

    protected AbstractRemoteDirectoryAdapter(DirectoryInstanceLoader directoryInstanceLoader, CrowdService crowdService) {
        this.directoryInstanceLoader = directoryInstanceLoader;
        this.crowdService = crowdService;
        this.okHttpClient = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    @Override
    public Principal findRemoteUser(final @Nonnull String findByAttributeName, @Nonnull String findByAttributeValue, @Nonnull Directory directory, @Nonnull AuthenticationTracker tracker, boolean fetchRemoteDirectories, boolean triggerUpdateInCrowd) throws SyncRequiredException {
        if (directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.CROWD) {
            if (!fetchRemoteDirectories) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "fetchRemoteDirectories is disabled, not searching in the remote directory {}", new Object[]{directory.getName()});
                return null;
            }
            if (triggerUpdateInCrowd) {
                if ("ATTR_NAME".equals(findByAttributeName)) {
                    this.triggerUpdateInCrowd(findByAttributeValue, directory, tracker);
                } else {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Trigger update in crowd is only available when using username as authentication attribute", new Object[0]);
                }
            }
            try {
                com.atlassian.crowd.model.user.User remoteUser;
                RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
                RemoteDirectory authoritativeDirectory = remoteDirectory.getAuthoritativeDirectory();
                if ("ATTR_NAME".equals(findByAttributeName)) {
                    remoteUser = authoritativeDirectory.findUserByName(findByAttributeValue);
                } else if ("ATTR_EMAIL".equals(findByAttributeName)) {
                    UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)findByAttributeValue), 0, 2);
                    List users = authoritativeDirectory.searchUsers((EntityQuery)eq);
                    if (users.isEmpty()) {
                        throw new UserNotFoundException("Remote user with email address " + findByAttributeValue + " was not found in directory " + directory.getName() + ".");
                    }
                    remoteUser = users.size() > 1 ? AbstractDirectoryAdapter.getSingleActiveUser(users, findByAttributeName, findByAttributeValue, remoteDirectory.getDescriptiveName(), tracker) : (com.atlassian.crowd.model.user.User)users.get(0);
                } else {
                    Property<String> property = new Property<String>(){

                        public String getPropertyName() {
                            return findByAttributeName;
                        }

                        public Class<String> getPropertyType() {
                            return String.class;
                        }
                    };
                    TermRestriction termRestriction = new TermRestriction((Property)property, MatchMode.EXACTLY_MATCHES, (Object)findByAttributeValue);
                    UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)termRestriction, 0, 2);
                    List users = authoritativeDirectory.searchUsers((EntityQuery)eq);
                    if (users.isEmpty()) {
                        throw new UserNotFoundException("Remote user with additionalId " + findByAttributeValue + " was not found in directory " + directory.getName() + ".");
                    }
                    remoteUser = users.size() > 1 ? AbstractDirectoryAdapter.getSingleActiveUser(users, findByAttributeName, findByAttributeValue, remoteDirectory.getDescriptiveName(), tracker) : (com.atlassian.crowd.model.user.User)users.get(0);
                }
                tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Found user in authorative directory: {}, {} ", new Object[]{remoteUser.getDisplayName(), remoteUser.getEmailAddress()});
                this.updateRemoteUser(directory, remoteDirectory, remoteUser.getName(), remoteUser, tracker);
                return remoteUser;
            }
            catch (UserNotFoundException e) {
                logger.debug("Remote user with <{}:{}> was not found in directory {}", new Object[]{findByAttributeName, findByAttributeValue, directory.getName()});
                return null;
            }
            catch (SyncRequiredException e) {
                throw e;
            }
            catch (Exception e) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Searching user <{}:{}> in remote directory {} failed", new Object[]{findByAttributeName, findByAttributeValue, directory.getName(), e});
                return null;
            }
        }
        logger.debug("{} of type {} is not a directory type for remote search", (Object)directory.getName(), (Object)directory.getType());
        return null;
    }

    private void updateRemoteUser(Directory directory, RemoteDirectory remoteDirectory, String userid, com.atlassian.crowd.model.user.User remoteUser, AuthenticationTracker tracker) throws UserNotFoundException, OperationFailedException, SyncRequiredException {
        if (remoteDirectory instanceof DelegatedAuthenticationDirectory) {
            boolean createUserEnabled = Boolean.parseBoolean(remoteDirectory.getValue("crowd.delegated.directory.auto.create.user"));
            boolean updateUserEnabled = Boolean.parseBoolean(remoteDirectory.getValue("crowd.delegated.directory.auto.update.user"));
            logger.debug("{}: createUserEnabled: {}, updateUserEnabled: {}", new Object[]{directory.getId(), createUserEnabled, updateUserEnabled});
            if (createUserEnabled || updateUserEnabled) {
                DelegatedAuthenticationDirectory delegatingDirectory = (DelegatedAuthenticationDirectory)remoteDirectory;
                logger.debug("{}: Triggering LDAP update", (Object)directory.getId());
                delegatingDirectory.addOrUpdateLdapUser(userid);
                this.assignDirectoryDefaultGroups((Principal)remoteUser, directory, tracker, true);
            } else {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Not updating remote user in directory {}, neither crowd.delegated.directory.auto.create.user nor crowd.delegated.directory.auto.update.user is enabled", new Object[]{remoteDirectory.getDirectoryId()});
            }
        } else if (remoteDirectory instanceof DbCachingRemoteDirectory) {
            DbCachingRemoteDirectory dbCachingRemoteDirectory = (DbCachingRemoteDirectory)remoteDirectory;
            if (logger.isDebugEnabled()) {
                logger.debug("Calling updateUserFromRemoteDirectory for {}", (Object)remoteDirectory);
            }
            try {
                dbCachingRemoteDirectory.updateUserFromRemoteDirectory(remoteUser);
            }
            catch (NoSuchMethodError e) {
                throw new SyncRequiredException(tracker);
            }
            this.assignDirectoryDefaultGroups((Principal)remoteUser, directory, tracker, true);
        } else {
            logger.warn("Directory {} is of unexpected class {}, not triggering user copy or something like that", (Object)remoteDirectory.getDescriptiveName(), (Object)remoteDirectory.getClass().getName());
        }
    }

    @Override
    public void updateRemoteUser(@Nonnull String userid, @Nonnull Directory directory, @Nonnull AuthenticationTracker tracker, boolean fetchRemoteDirectories, boolean triggerUpdateInCrowd) {
        block12: {
            logger.debug("updateRemoteUser is called");
            try {
                if (directory.getType() == DirectoryType.DELEGATING || directory.getType() == DirectoryType.CONNECTOR || directory.getType() == DirectoryType.CROWD) {
                    RemoteDirectory remoteDirectory;
                    if (!fetchRemoteDirectories) {
                        tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "fetchRemoteDirectories is disabled, not updating the user from the remote directory {}", new Object[]{directory.getName()});
                        return;
                    }
                    if (triggerUpdateInCrowd) {
                        this.triggerUpdateInCrowd(userid, directory, tracker);
                    }
                    if ((remoteDirectory = this.directoryInstanceLoader.getDirectory(directory)) instanceof DelegatedAuthenticationDirectory) {
                        logger.debug("This is a DELEGATING directory, calling addOrUpdateLdapUser for {}", (Object)userid);
                        DelegatedAuthenticationDirectory delegatingDirectory = (DelegatedAuthenticationDirectory)remoteDirectory;
                        boolean createUserEnabled = Boolean.parseBoolean(remoteDirectory.getValue("crowd.delegated.directory.auto.create.user"));
                        boolean updateUserEnabled = Boolean.parseBoolean(remoteDirectory.getValue("crowd.delegated.directory.auto.update.user"));
                        if (createUserEnabled || updateUserEnabled) {
                            logger.debug("{}: triggering LDAP update", (Object)delegatingDirectory.getDirectoryId());
                            delegatingDirectory.addOrUpdateLdapUser(userid);
                        } else {
                            logger.debug("{} is not configured for user update, not triggering LDAP update", (Object)delegatingDirectory.getDirectoryId());
                        }
                        break block12;
                    }
                    RemoteDirectory authoritativeDirectory = remoteDirectory instanceof DbCachingRemoteDirectory ? remoteDirectory.getAuthoritativeDirectory() : remoteDirectory;
                    com.atlassian.crowd.model.user.User user = authoritativeDirectory.findUserByName(userid);
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Calling updateUserFromRemoteDirectory for {}", (Object)user);
                        }
                        remoteDirectory.updateUserFromRemoteDirectory(user);
                        break block12;
                    }
                    catch (NoSuchMethodError e) {
                        throw new SyncRequiredException(tracker);
                    }
                }
                logger.debug("Not updating the remote user from directory of type {}", (Object)directory.getType());
            }
            catch (UserNotFoundException e) {
                logger.warn("Userid {} was not found in the remote directory", (Object)userid);
            }
            catch (Exception e) {
                logger.warn("updateRemoteUser failed", (Throwable)e);
                tracker.add(e);
            }
        }
    }

    @Override
    public void assignDirectoryDefaultGroups(@Nonnull Principal principal, @Nonnull Directory directory, @Nonnull AuthenticationTracker tracker) {
        this.assignDirectoryDefaultGroups(principal, directory, tracker, false);
    }

    private boolean isAssignDirectoryDefaultGroups(@Nonnull Principal principal, @Nonnull Directory directory) {
        boolean addEveryLogin;
        if (!directory.getType().equals((Object)DirectoryType.CONNECTOR)) {
            logger.debug("Directory {}: {} is not of type CONNECTOR, skipping group assignment", (Object)directory.getId(), (Object)directory.getName());
            return false;
        }
        String syncConfig = directory.getValue("crowd.sync.group.membership.after.successful.user.auth.enabled");
        boolean bl = addEveryLogin = syncConfig != null && syncConfig.equals("true");
        if (addEveryLogin) {
            logger.debug("Directory {}: {} is configured to add groups on every login", (Object)directory.getId(), (Object)directory.getName());
            return true;
        }
        boolean addFirst = syncConfig == null || syncConfig.equals("only_when_first_created");
        logger.debug("Directory {}: {} add groups on first login: {}", new Object[]{directory.getId(), directory.getName(), addFirst});
        boolean firstLogin = this.isFirstLogin(principal);
        logger.debug("Is first login for user {} in directory {}: {}", new Object[]{principal.getName(), directory.getName(), firstLogin});
        return addFirst && firstLogin;
    }

    @Nonnull
    public static List<String> readAutoAddGroups(@Nonnull Directory directory) {
        String groupString = directory.getValue(AUTO_ADD_GROUPS_DIRECTORY_ATTRIBUTE);
        if (groupString == null || groupString.trim().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> groupList = groupString.contains("|") ? Arrays.asList(groupString.split("\\|")) : Arrays.asList(groupString.split(","));
        if (logger.isDebugEnabled()) {
            logger.debug("autoAddGroups for directory {} are {}", (Object)directory.getName(), (Object)String.join((CharSequence)",", groupList));
        }
        return groupList;
    }

    protected void assignDirectoryDefaultGroups(Principal principal, Directory directory, AuthenticationTracker tracker, boolean always) {
        if (!directory.getType().equals((Object)DirectoryType.INTERNAL)) {
            if (always || this.isAssignDirectoryDefaultGroups(principal, directory)) {
                try {
                    User user = this.crowdService.getUser(principal.getName());
                    if (user == null) {
                        tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "User for principal {} is null, cannot add default directory groups", new Object[]{principal.getName()});
                    }
                    for (String groupName : AbstractRemoteDirectoryAdapter.readAutoAddGroups(directory)) {
                        if (groupName.trim().isEmpty()) {
                            logger.warn("groupName is empty, skipping");
                            continue;
                        }
                        logger.trace("Checking whether user is member of {}", (Object)groupName);
                        Group group = this.crowdService.getGroup(groupName);
                        if (group == null || this.crowdService.isUserMemberOfGroup(user, group)) continue;
                        try {
                            if (!this.crowdService.addUserToGroup(user, group)) continue;
                            logger.debug("added {} to group {}", (Object)user.getName(), (Object)group.getName());
                        }
                        catch (Exception groupException) {
                            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Adding {} to group {} failed", new Object[]{user.getName(), group.getName(), groupException});
                        }
                    }
                }
                catch (Exception e) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Adding default directory groups failed, see ExceptionInfo", new Object[0]);
                    tracker.add(e);
                }
            } else {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "No need to add this user to the directory default groups", new Object[0]);
            }
        }
    }

    @Override
    public void triggerUpdateInCrowd(@Nonnull String userid, @Nonnull Directory directory, AuthenticationTracker tracker) {
        if (directory.getType() == DirectoryType.CROWD) {
            logger.debug("This is a CROWD-directory, triggering update there...");
            if (this.callNotifyRestEndpointInCrowd(userid, directory, tracker)) {
                return;
            }
            tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Request to /notify on crowd server resulted in 404, trying the old method.", new Object[0]);
            String crowdServerUrl = (String)directory.getAttributes().get("crowd.server.url");
            if (!crowdServerUrl.endsWith("/")) {
                crowdServerUrl = crowdServerUrl + "/";
            }
            String triggerUrl = crowdServerUrl + "rest/de.resolution.updateuserfromremotedirectory/1.0/";
            logger.debug("URL for triggering update is {}", (Object)triggerUrl);
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)userid);
            Request request = new Request.Builder().put(body).url(triggerUrl).build();
            try (Response response = this.okHttpClient.newCall(request).execute();){
                if (response.code() != 204 && logger.isWarnEnabled()) {
                    logger.warn("Unexpected response code: {}, message: {}", (Object)response.code(), (Object)response.message());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("HTTP response status is {}: {}", (Object)response.code(), (Object)response.message());
                }
            }
            catch (IOException ioexception) {
                logger.warn("HTTP request to Crowd failed: ", (Throwable)ioexception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean callNotifyRestEndpointInCrowd(String userid, Directory directory, AuthenticationTracker tracker) {
        Map attributes = directory.getAttributes();
        String crowdUrlString = (String)attributes.get("crowd.server.url");
        if (crowdUrlString == null || crowdUrlString.isEmpty()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Directory attribute crowd.server.url is null or empty, skipping triggering rest/usermanagement/1/authentication/notify", new Object[0]);
            return true;
        }
        String username = (String)attributes.get("application.name");
        if (username == null || username.isEmpty()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Directory attribute application.name is null or empty, skipping triggering rest/usermanagement/1/authentication/notify", new Object[0]);
            return true;
        }
        String password = (String)attributes.get("application.password");
        if (password == null || password.isEmpty()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Directory attribute application.password is null or empty, skipping triggering rest/usermanagement/1/authentication/notify", new Object[0]);
            return true;
        }
        HttpUrl crowdUrl = HttpUrl.parse((String)crowdUrlString);
        if (crowdUrl == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Parsing Crowd URL returned null, skipping triggering rest/usermanagement/1/authentication/notify", new Object[0]);
            return true;
        }
        crowdUrl = crowdUrl.newBuilder().addPathSegments(PATH_TO_CROWD_NOTIFY).addQueryParameter("username", userid).build();
        Request request = new Request.Builder().header("Authorization", Credentials.basic((String)username, (String)password)).header("Accept", "application/json").post(RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)"{}")).url(crowdUrl).build();
        try (Response response = this.okHttpClient.newCall(request).execute();){
            if (response.code() == 404) {
                boolean bl2 = false;
                return bl2;
            }
            if (!response.isSuccessful()) {
                ResponseBody body = response.body();
                String bodyAsString = body == null ? "NULL" : body.string();
                tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Unexpected response triggering rest/usermanagement/1/authentication/notify on Crowd: {}, {}", new Object[]{response.code(), bodyAsString});
            } else {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Triggering rest/usermanagement/1/authentication/notify on Crowd was successful.", new Object[0]);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.warn("HTTP request to notify Crowd failed: ", (Throwable)e);
            return true;
        }
    }

    protected abstract boolean isFirstLogin(Principal var1);
}

