/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SAMLSSORuntimeException;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.idpselection.DefaultIdpSelector;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByRequestHeaderSelector;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.OAuth2SpecificHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OidcSpecificHelpers;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.atlasplugins.samlsso.servlet.IdPForSelection;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.LoginHandler;
import com.resolution.samlwrapper.api.LogoutHandler;
import com.resolution.samlwrapper.api.ProgressLogger;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.exception.LoginHandlerException;
import com.resolution.samlwrapper.api.exception.LogoutHandlerException;
import com.resolution.samlwrapper.api.exception.SAMLWrapperException;
import com.resolution.samlwrapper.api.exception.SamlAuthenticationException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import com.resolution.samlwrapper.osj.PerformanceTestHelper;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.impl.ClusterNodeInformation;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import okhttp3.HttpUrl;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
public class SamlSsoServlet
extends BasicServlet {
    private static final Logger logger = LoggerFactory.getLogger(SamlSsoServlet.class);
    private static final String UTF8 = "UTF-8";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String OS_DESTINATION_PART = "&os_destination=";
    public static final String ADDITIONAL_AUTHENTICATION_PARAMETER = "additional";
    public static final String PASSWORD_LINK = "passwordLink";
    public static final String LOGINURL = "loginurl";
    public static final String SAVE_IDP_SELECTION = "saveIdpSelection";
    public static final String REDIRECT_TO = "redirectTo";
    private static final String LOGIN_HINT = "loginHint";
    private static final String DOMAIN_HINT = "domain_hint";
    private final LicenseChecker licenseChecker;
    private final LogoutHandler logoutHandler;
    private final LoginHandler loginHandler;
    private final AuthenticationTrackerRepository authenticationTrackerRepository;
    private final IdpByRequestHeaderSelector idpByRequestHeaderSelector;
    private final DefaultIdpSelector defaultIdpSelector;
    private final String clusterNodeId;
    private static final String IDP_COOKIE_NAME = "selectedidp";
    private static final int IDP_COOKIE_LIFETIME = 31536000;
    private static final long IDP_COOKIE_LIFETIME_MILLIS = 31536000000L;
    private static final long serialVersionUID = 1L;

    @Inject
    public SamlSsoServlet(SamlSsoService samlSsoService, LicenseChecker licenseChecker, LoginHandler loginHander, LogoutHandler logoutHandler, AuthenticationTrackerRepository authenticationTrackerRepository, @ComponentImport TemplateRenderer renderer, IdpByRequestHeaderSelector idpByRequestHeaderSelector, DefaultIdpSelector defaultIdpSelector, ClusterNodeInformation clusterNodeInformation) {
        super(samlSsoService, renderer);
        this.licenseChecker = licenseChecker;
        this.loginHandler = loginHander;
        this.logoutHandler = logoutHandler;
        this.authenticationTrackerRepository = authenticationTrackerRepository;
        this.idpByRequestHeaderSelector = idpByRequestHeaderSelector;
        this.defaultIdpSelector = defaultIdpSelector;
        this.clusterNodeId = clusterNodeInformation.getNodeId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processRequest(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) throws ServletException, IOException {
        int idpid;
        String originalUrl;
        String domainHintValue;
        String loginHintValue;
        AuthenticationTracker tracker;
        SAMLWrapper samlWrapper;
        block68: {
            CommonRunningIdpConfiguration selectedIdpConfig;
            String notificationEmail;
            block74: {
                block73: {
                    block69: {
                        AuthenticationTracker trackerForTokenAuth;
                        boolean rememberMe;
                        String ssoToken;
                        block71: {
                            block72: {
                                String trackerId;
                                block70: {
                                    PerformanceTestHelper.log((String)"Incoming Request");
                                    ProgressLogger.log((String)"Incoming request to SamlSsoServlet");
                                    resp.setHeader("X-XSS-Protection", "1; mode=block");
                                    resp.setHeader("X-Content-Type-Options", "nosniff");
                                    LicenseStatus lc = this.licenseChecker.checkLicense();
                                    if (!lc.isLicensed() && lc.isEnforced()) {
                                        this.sendError(resp, null, lc.getMessage(), null);
                                        return;
                                    }
                                    if (!this.samlSsoService.isReady()) {
                                        this.sendError(resp, null, "SAML SingleSignOn is not initialized, check the configuration", null);
                                        return;
                                    }
                                    ssoToken = req.getParameter("ssoservlettoken");
                                    boolean bl = rememberMe = req.getParameter("rememberme") != null;
                                    if (ssoToken == null) break block69;
                                    trackerId = ssoToken.substring(0, 15);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("Extracted tracker id {} from token {}", (Object)StringUtil.sanitize((String)trackerId), (Object)StringUtil.sanitize((String)ssoToken));
                                    }
                                    ProgressLogger.log((String)"Found ssotoken", (String)trackerId);
                                    if (!this.authenticationTrackerRepository.has(trackerId)) break block70;
                                    trackerForTokenAuth = (AuthenticationTracker)this.authenticationTrackerRepository.get(trackerId, false);
                                    if (!logger.isDebugEnabled()) break block71;
                                    break block72;
                                }
                                if (logger.isWarnEnabled()) {
                                    logger.warn("No tracker found for id {} while executing token authentication", (Object)StringUtil.sanitize((String)trackerId));
                                }
                                this.sendError(resp, null, "No tracker found for token authentication", null);
                                return;
                            }
                            logger.debug("Authenticating user by SSO-Token {}", (Object)StringUtil.sanitize((String)ssoToken));
                        }
                        trackerForTokenAuth.add(com.resolution.samlwrapper.api.Utils.createRequestInfo((HttpServletRequest)req, (String)this.clusterNodeId));
                        try {
                            this.loginHandler.authenticateByToken(req, resp, ssoToken, rememberMe, (SAMLAuthenticationTracker)trackerForTokenAuth);
                            return;
                        }
                        catch (SamlAuthenticationException e) {
                            trackerForTokenAuth.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                            this.sendError(resp, null, "User Login by Token failed: " + e.getMessage(), e);
                            return;
                        }
                    }
                    samlWrapper = this.samlSsoService.getSamlWrapper();
                    try {
                        boolean hadSAMLMessage = samlWrapper.handleSAMLMessage(req, resp, this.loginHandler, this.logoutHandler, this.clusterNodeId);
                        if (hadSAMLMessage) {
                            logger.debug("handleSAMLMessage returned true, we're done here");
                            return;
                        }
                    }
                    catch (SAMLWrapperException e) {
                        if (e.getTracker() instanceof AuthenticationTracker) {
                            AuthenticationTracker tracker2 = (AuthenticationTracker)e.getTracker();
                            tracker2.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                            tracker2.add(com.resolution.samlwrapper.api.Utils.createRequestInfo((HttpServletRequest)req, (String)this.clusterNodeId));
                        }
                        logger.debug("SAMLWrapper threw exception", (Throwable)e);
                        this.sendError(resp, null, "SAML-Login failed: " + e.getMessage(), e.getStatusMessage(), e);
                        return;
                    }
                    catch (LoginHandlerException e) {
                        if (e.getTracker() instanceof AuthenticationTracker) {
                            AuthenticationTracker tracker3 = (AuthenticationTracker)e.getTracker();
                            tracker3.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                            tracker3.add(com.resolution.samlwrapper.api.Utils.createRequestInfo((HttpServletRequest)req, (String)this.clusterNodeId));
                        }
                        this.sendError(resp, null, "User Login failed: " + e.getMessage(), e);
                        return;
                    }
                    catch (LogoutHandlerException e) {
                        if (e.getTracker() instanceof AuthenticationTracker) {
                            AuthenticationTracker tracker4 = (AuthenticationTracker)e.getTracker();
                            tracker4.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                            tracker4.add(com.resolution.samlwrapper.api.Utils.createRequestInfo((HttpServletRequest)req, (String)this.clusterNodeId));
                        }
                        this.sendError(resp, null, "User Logout failed: " + e.getMessage(), e);
                        return;
                    }
                    String trackerIdFromParameter = req.getParameter("tracker");
                    if (trackerIdFromParameter == null) break block73;
                    if (this.authenticationTrackerRepository.has(trackerIdFromParameter)) {
                        tracker = (AuthenticationTracker)this.authenticationTrackerRepository.get(trackerIdFromParameter, false);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Retrieved tracker with id {} from parameter {}", (Object)StringUtil.sanitize((String)tracker.getTrackerId()), (Object)"tracker");
                        }
                        break block74;
                    } else {
                        tracker = (AuthenticationTracker)this.authenticationTrackerRepository.create();
                        tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Created new tracker because the id {} was not found.", new Object[]{tracker.getTrackerId()});
                    }
                    break block74;
                }
                tracker = (AuthenticationTracker)this.authenticationTrackerRepository.create();
                logger.debug("Created new tracker with Id {}", (Object)tracker.getTrackerId());
            }
            tracker.add(com.resolution.samlwrapper.api.Utils.createRequestInfo((HttpServletRequest)req, (String)this.clusterNodeId));
            loginHintValue = StringUtil.sanitize((String)req.getParameter(LOGIN_HINT));
            domainHintValue = StringUtil.sanitize((String)req.getParameter(DOMAIN_HINT));
            if (req.getParameterMap().containsKey(ADDITIONAL_AUTHENTICATION_PARAMETER)) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Requesting additional authentication", new Object[0]);
                ProgressLogger.log((String)"Requesting additional authentication", (SAMLAuthenticationTracker)tracker);
                HttpSession session = req.getSession(false);
                if (session == null) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "WebSudo: Looks like there is no session to be confirmed", new Object[0]);
                    return;
                }
                String idpEntityId = (String)session.getAttribute("identityProvider");
                if (idpEntityId == null) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "WebSudo: No idp id", new Object[0]);
                    return;
                }
                CommonRunningIdpConfiguration commonRunningIdpConfiguration = this.samlSsoService.getRunningConfiguration().getRunningIdpConfiguration(idpEntityId);
                if (commonRunningIdpConfiguration == null) {
                    this.sendError(resp, null, "Could not retrieve config for reauthentication", null);
                    return;
                }
                ProtocolType protocolType = commonRunningIdpConfiguration.getProtocolType();
                if (protocolType == ProtocolType.SAML) {
                    try {
                        samlWrapper.requestAdditionalAuthentication(req, resp, this.samlSsoService.getAbsoluteSsoURL(), (SAMLAuthenticationTracker)tracker);
                        return;
                    }
                    catch (SAMLWrapperException e) {
                        tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                        this.sendError(resp, null, "Requesting additional authentication failed: " + e.getMessage(), e);
                    }
                    return;
                }
                if (protocolType == ProtocolType.OIDC) {
                    OidcSpecificHelpers.initiateLogin((OidcRunningIdpConfiguration)commonRunningIdpConfiguration, resp, this.samlSsoService.getAbsoluteBaseUrl(), tracker, true, loginHintValue, domainHintValue);
                    return;
                }
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Not supported protocol for websudo: {}", new Object[]{tracker.getProtocolType()});
            }
            if ((notificationEmail = req.getParameter("notify")) != null) {
                if (this.samlSsoService.getRunningConfiguration().getAllowedNotificationEmailAddresses().contains(notificationEmail)) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "State changes are emailed to {}", new Object[]{notificationEmail});
                    tracker.setNotificationMail(notificationEmail);
                } else {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Notification address {} is not on the whitelist, no notification emails will be sent", new Object[]{notificationEmail});
                }
            }
            String defaultRedirectUrl = this.runningConfiguration.getDefaultRedirectUrl();
            originalUrl = req.getParameter(REDIRECT_TO);
            if (originalUrl == null || originalUrl.equals("null")) {
                logger.debug("No original URL in request, using {}", (Object)defaultRedirectUrl);
                originalUrl = defaultRedirectUrl;
            }
            if (originalUrl.equals("/plugins/servlet/samlsso/logout") || originalUrl.equals("/plugins/servlet/samlsso/loggedoutpage")) {
                logger.debug("Found {} in redirectTo, using {} instead.", (Object)originalUrl, (Object)defaultRedirectUrl);
                originalUrl = defaultRedirectUrl;
            }
            if (originalUrl.contains(" ")) {
                originalUrl = originalUrl.replace(" ", "%20");
            }
            tracker.setOriginalUrl(originalUrl);
            logger.debug("Original url is {}", (Object)originalUrl);
            if (this.samlSsoService.isLoggedInUser(req)) {
                ProgressLogger.log((String)"There is a user in the session, redirecting", (SAMLAuthenticationTracker)tracker);
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "There is already a user in this session, just redirecting to {}", new Object[]{originalUrl});
                String redirectURL = this.samlSsoService.getRedirectURL(req, originalUrl, tracker);
                logger.debug("Redirect URL is {}", (Object)redirectURL);
                tracker.setFullRedirectUrl(redirectURL);
                resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
                resp.sendRedirect(redirectURL);
                tracker.setStatus(SAMLAuthenticationTracker.Status.SESSION_PRESENT);
                return;
            }
            if (req.getParameter("selectidp") != null) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "selectidp parameter is present, rendering selection page", new Object[0]);
                this.sendIdpSelectionPage(resp, originalUrl, 0, tracker);
                return;
            }
            if (req.getParameter("idpbyemail") != null) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "idpbyemail parameter is present, rendering selection by email page", new Object[0]);
                this.sendIdpSelectionByEmailPage(resp, originalUrl, 0, tracker);
                return;
            }
            idpid = 0;
            int idpidFromCookie = 0;
            String idpIdString = req.getParameter("idp");
            String idpEntityIdString = req.getParameter("entityID");
            idpid = this.idpByRequestHeaderSelector.selectIdpByRequestHeader(req, tracker);
            if (idpIdString != null) {
                try {
                    idpid = Integer.parseInt(idpIdString.trim());
                }
                catch (NumberFormatException e) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "IDP id '{}' is invalid", new Object[]{idpIdString});
                    tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                    this.sendError(resp, null, "IDP id '" + idpIdString + "' is invalid", e);
                    return;
                }
            }
            if (idpEntityIdString != null && !idpEntityIdString.trim().isEmpty() && (selectedIdpConfig = this.runningConfiguration.getRunningIdpConfiguration(idpEntityIdString)) != null) {
                idpid = selectedIdpConfig.getId();
                if (logger.isDebugEnabled()) {
                    logger.debug("Selecting idp id {} from entityid-parameter {}", (Object)idpid, (Object)StringUtil.sanitize((String)idpEntityIdString));
                }
            }
            if (idpid > 0) {
                if (SamlSsoServlet.shouldStoreSelectedIdPInCookie(req)) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Storing selected IdP {} in cookie {}", new Object[]{idpid, IDP_COOKIE_NAME});
                    String setCookieString = SamlSsoServlet.getCookieHeaderString(String.valueOf(idpid), this.samlSsoService.isHttps(), false, this.samlSsoService.getRelativeCanonicalBaseUrl());
                    resp.addHeader(SET_COOKIE, setCookieString);
                    logger.debug("processRequest() - New selectedIdp cookie was just set: {}", (Object)setCookieString);
                } else {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Selected IdP {} is not stored in cookie", new Object[]{idpid});
                }
            } else if (idpid == 0) {
                Cookie[] cookies = req.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (!cookie.getName().equals(IDP_COOKIE_NAME)) continue;
                        if (cookie.getValue() == null) break;
                        try {
                            idpidFromCookie = Integer.parseInt(cookie.getValue());
                            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Found idp {} in cookie", new Object[]{idpidFromCookie});
                        }
                        catch (NumberFormatException e) {
                            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Cookie value {} is not parseable, setting id to 0.", new Object[]{cookie.getValue()});
                            idpidFromCookie = 0;
                        }
                        break;
                    }
                }
                if (this.runningConfiguration.isEnableIdPSelection()) {
                    this.sendIdpSelectionPage(resp, originalUrl, idpidFromCookie, tracker);
                    return;
                }
                if (this.runningConfiguration.isEnableIdPSelectionByEmailAddress()) {
                    if (idpidFromCookie != 0 && !this.runningConfiguration.isShowSelectionPageWhenEmailCookie()) {
                        idpid = idpidFromCookie;
                        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Skipping IdP by email page, found IdP {} in Cookie", new Object[]{idpidFromCookie});
                        break block68;
                    } else {
                        this.sendIdpSelectionByEmailPage(resp, originalUrl, idpidFromCookie, tracker);
                        return;
                    }
                }
                idpid = this.defaultIdpSelector.getDefaultIdPId();
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Using default IdP {}", new Object[]{idpid});
            }
        }
        if (idpid < 0) {
            HttpUrl loginUrl = HttpUrl.parse((String)this.samlSsoService.getAbsoluteNoSsoUrl());
            if (loginUrl == null) {
                throw new SAMLSSORuntimeException("Failed to parse no sso login page URL from " + this.samlSsoService.getAbsoluteNoSsoUrl(), null);
            }
            HttpUrl.Builder loginUrlBuilder = loginUrl.newBuilder();
            loginUrlBuilder.addQueryParameter("os_destination", originalUrl);
            if (loginHintValue != null && !loginHintValue.trim().isEmpty() && this.runningConfiguration.isSendEmailAddressToLoginPage()) {
                loginUrlBuilder.addQueryParameter("os_username", loginHintValue);
            }
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Idpid is {}, redirecting to login URL {}", new Object[]{idpid, loginUrl});
            tracker.setStatus(SAMLAuthenticationTracker.Status.LOGIN_PAGE);
            resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            ProgressLogger.log((String)"Redirecting to login", (SAMLAuthenticationTracker)tracker);
            resp.sendRedirect(loginUrlBuilder.build().toString());
            return;
        }
        Enumeration paramNames = req.getParameterNames();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String encodedParamName = Encode.forHtml((String)paramName);
            if (paramName.equals(REDIRECT_TO) || paramName.equals("idp") || paramName.equals("tracker") || paramName.equals(SAVE_IDP_SELECTION) || paramName.equals(LOGIN_HINT)) continue;
            String paramValue = req.getParameter(paramName);
            String encodedParamValue = Encode.forHtml((String)paramValue);
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Passing through encoded parameter {}, encoded value '{}'", new Object[]{encodedParamName, encodedParamValue});
            paramMap.put(encodedParamName, encodedParamValue);
        }
        CommonRunningIdpConfiguration idpConfig = this.runningConfiguration.getRunningIdpConfiguration(idpid);
        if (idpConfig == null) {
            logger.debug("Using default IdP configuration");
            idpConfig = this.runningConfiguration.getFirstRunningIdpConfiguration();
            if (idpConfig == null) {
                this.sendError(resp, null, "Initiating SAML Single Sign on failed, no valid IDP configuration available.", null);
                return;
            }
        }
        if (idpConfig.getProtocolType() == ProtocolType.SAML) {
            try {
                tracker.setProtocolType(ProtocolType.SAML);
                tracker.setStatus(SAMLAuthenticationTracker.Status.IN_PROGRESS);
                if (idpConfig.shouldSendLoginHint()) {
                    samlWrapper.initiateLogin(req, resp, idpConfig.getIdpId(), originalUrl, paramMap, this.samlSsoService.getAbsoluteSsoURL(), (SAMLAuthenticationTracker)tracker, idpConfig.getLoginHintParameterName(), loginHintValue);
                    return;
                }
                samlWrapper.initiateLogin(req, resp, idpConfig.getIdpId(), originalUrl, paramMap, this.samlSsoService.getAbsoluteSsoURL(), (SAMLAuthenticationTracker)tracker, null, null);
                return;
            }
            catch (SAMLWrapperException e) {
                tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                tracker.add(e);
                this.sendError(resp, null, "Initiating SAML Single Sign on failed: " + e.getMessage(), e);
                return;
            }
        }
        if (idpConfig.getProtocolType() == ProtocolType.OIDC) {
            try {
                tracker.setProtocolType(ProtocolType.OIDC);
                OidcSpecificHelpers.initiateLogin((OidcRunningIdpConfiguration)idpConfig, resp, this.samlSsoService.getAbsoluteBaseUrl(), tracker, loginHintValue, domainHintValue);
                return;
            }
            catch (Exception e) {
                tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
                tracker.add(e);
                this.sendError(resp, null, "Initiating OIDC Single Sign on failed: " + e.getMessage(), e);
                return;
            }
        }
        if (idpConfig.getProtocolType() != ProtocolType.OAU2) {
            this.sendError(resp, null, "Unknown Idp config encountered, was: " + idpConfig.getClass(), null);
            return;
        }
        try {
            tracker.setProtocolType(ProtocolType.OAU2);
            OAuth2SpecificHelpers.initiateLogin((OAuth2RunningIdpConfiguration)idpConfig, resp, this.samlSsoService.getAbsoluteBaseUrl(), tracker);
            return;
        }
        catch (Exception e) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            tracker.add(e);
            this.sendError(resp, null, "Initiating OAuth2/Social Login failed: " + e.getMessage(), e);
            return;
        }
    }

    private static boolean shouldStoreSelectedIdPInCookie(@Nonnull HttpServletRequest httpServletRequest) {
        String[] values = httpServletRequest.getParameterValues(SAVE_IDP_SELECTION);
        if (values == null || values.length == 0) {
            return true;
        }
        return Arrays.stream(values).anyMatch(Boolean::parseBoolean);
    }

    private void sendIdpSelectionByEmailPage(HttpServletResponse response, String originalUrl, int lastIdpId, AuthenticationTracker tracker) throws IOException {
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Sending IdP selection by email page", new Object[0]);
        ProgressLogger.log((String)"Sending IdP by email page", (SAMLAuthenticationTracker)tracker);
        tracker.setStatus(SAMLAuthenticationTracker.Status.IDP_SELECTION);
        originalUrl = URLEncoder.encode(originalUrl, UTF8);
        String setCookieString = SamlSsoServlet.getCookieHeaderString("", this.samlSsoService.isHttps(), false, this.samlSsoService.getRelativeCanonicalBaseUrl());
        response.addHeader(SET_COOKIE, setCookieString);
        response.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        logger.debug("sendIdpSelectionByEmailPage() - New selectedIdp cookie was just set: {}", (Object)setCookieString);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        String ssourl = this.samlSsoService.getRelativeInitiateSSOUrl() + "?tracker=" + tracker.getTrackerId() + "&idp=IDPID&redirectTo=" + originalUrl;
        String lastSsourl = this.samlSsoService.getRelativeInitiateSSOUrl() + "?tracker=" + tracker.getTrackerId() + "&idp=" + lastIdpId + "&redirectTo=" + originalUrl;
        String loginUrl = this.generateNossoLoginUrlForIdpSelectionPage(originalUrl);
        if (this.runningConfiguration.isNossoEnabled()) {
            ctx.put(LOGINURL, loginUrl);
            ctx.put(PASSWORD_LINK, loginUrl);
        } else {
            ctx.put(PASSWORD_LINK, "");
        }
        if (this.runningConfiguration.getIdpByEmailPageJavaScript() != null && !this.runningConfiguration.getIdpByEmailPageJavaScript().trim().isEmpty()) {
            ctx.put("pageScript", this.runningConfiguration.getIdpByEmailPageJavaScript());
        }
        ctx.put("ssourl", ssourl);
        ctx.put("lastSsourl", lastSsourl);
        ctx.put("lastidp", lastIdpId);
        ctx.put("emailDomainMap", "{\"__emailDomainCheck\":\"" + this.samlSsoService.getRelativeBaseUrl() + "/rest/samlsso-admin/1.0/idpByEmail/\"}");
        ctx.put("checkEmailDomainUrl", this.samlSsoService.getRelativeBaseUrl() + "/rest/samlsso-admin/1.0/idpByEmail/");
        response.setContentType("text/html;charset=utf-8");
        String template = this.runningConfiguration.getIdpByEmailPageTemplate();
        String result = this.renderer.renderFragment(template, ctx);
        result = Utils.unescapeHTML(result);
        if (logger.isDebugEnabled()) {
            logger.debug("### Rendered IdP by Email page: {}", (Object)result);
        }
        ProgressLogger.log((String)"Writing to response", (SAMLAuthenticationTracker)tracker);
        response.getWriter().write(result);
    }

    private void sendIdpSelectionPage(HttpServletResponse resp, String originalUrl, int idpFromCookie, AuthenticationTracker tracker) throws IOException {
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Sending IdP selection page", new Object[0]);
        ProgressLogger.log((String)"Sending IdP selection page", (SAMLAuthenticationTracker)tracker);
        tracker.setStatus(SAMLAuthenticationTracker.Status.IDP_SELECTION);
        originalUrl = URLEncoder.encode(originalUrl, UTF8);
        String setCookieString = SamlSsoServlet.getCookieHeaderString("", this.samlSsoService.isHttps(), false, this.samlSsoService.getRelativeCanonicalBaseUrl());
        resp.addHeader(SET_COOKIE, setCookieString);
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        logger.debug("sendIdpSelectionPage() - New selectedIdp cookie was just set: {}", (Object)setCookieString);
        String fragment = this.runningConfiguration.getIdpSelectionPageTemplate();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        String loginUrl = this.generateNossoLoginUrlForIdpSelectionPage(originalUrl);
        if (this.runningConfiguration.isNossoEnabled()) {
            ctx.put(LOGINURL, loginUrl);
            ctx.put(PASSWORD_LINK, loginUrl);
        } else {
            ctx.put(PASSWORD_LINK, "");
        }
        ctx.put("ssourl", this.samlSsoService.getRelativeInitiateSSOUrl());
        String idpUrlFromCookie = null;
        String nameFromCookie = null;
        String descriptionFromCookie = null;
        ArrayList<IdPForSelection> selectionList = new ArrayList<IdPForSelection>();
        for (CommonRunningIdpConfiguration current : this.runningConfiguration.getRunningIdPConfigurations()) {
            String idpurl = this.samlSsoService.getRelativeInitiateSSOUrl() + "?tracker=" + tracker.getTrackerId() + "&idp=" + current.getId() + "&redirectTo=" + originalUrl;
            IdPForSelection idPForSelection = new IdPForSelection(idpurl, current.getName(), current.getDescription(), current.getId(), current.getWeight());
            selectionList.add(idPForSelection);
            if (current.getId() != idpFromCookie) continue;
            idpUrlFromCookie = idpurl;
            nameFromCookie = current.getName();
            descriptionFromCookie = current.getDescription() == null ? "" : current.getDescription();
        }
        ArrayList<IdPForSelection> idpsByWeight = new ArrayList<IdPForSelection>(selectionList);
        idpsByWeight.sort(IdPForSelection.BY_WEIGHT);
        ArrayList<IdPForSelection> idpsByName = new ArrayList<IdPForSelection>(selectionList);
        idpsByName.sort(IdPForSelection.BY_NAME);
        ctx.put("idps", selectionList);
        ctx.put("idpsByWeight", idpsByWeight);
        ctx.put("idpsByName", idpsByName);
        ctx.put("trackerId", tracker.getTrackerId());
        ctx.put(REDIRECT_TO, URLDecoder.decode(originalUrl, UTF8));
        ctx.put("selectedUrl", idpUrlFromCookie);
        ctx.put("selectedName", nameFromCookie);
        ctx.put("selectedDescription", descriptionFromCookie);
        ctx.put("idpSelected", idpUrlFromCookie != null);
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Last selected idp is {}", new Object[]{nameFromCookie});
        resp.setContentType("text/html;charset=utf-8");
        String result = this.renderer.renderFragment(fragment, ctx);
        result = Utils.unescapeHTML(result);
        ProgressLogger.log((String)"Writing to response", (SAMLAuthenticationTracker)tracker);
        resp.getWriter().write(result);
    }

    @Nonnull
    private String generateNossoLoginUrlForIdpSelectionPage(String originalUrl) {
        String loginUrl = this.samlSsoService.getRelativeNossoLoginPageUrl() + OS_DESTINATION_PART + originalUrl;
        if (this.samlSsoService.isJiraServiceDesk() && originalUrl.contains("%2Fportal%2")) {
            loginUrl = this.samlSsoService.getRelativeBaseUrl() + "/servicedesk/customer/user/login?nosso&destination=" + originalUrl.replaceFirst("%2Fservicedesk%2Fcustomer%2F", "");
        }
        return loginUrl;
    }

    private static String getCookieHeaderString(String selectedIdp, boolean isHTTPS, boolean isExpired, String path) {
        String expireDateGMTString;
        Date expireDate;
        SimpleDateFormat dateFormatGMT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");
        dateFormatGMT.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (isExpired) {
            expireDate = new Date(0L);
            expireDateGMTString = dateFormatGMT.format(expireDate);
        } else {
            expireDate = new Date(System.currentTimeMillis() + 31536000000L);
            expireDateGMTString = dateFormatGMT.format(expireDate);
        }
        String maxAgeString = "0";
        if (!isExpired) {
            maxAgeString = String.valueOf(31536000);
        }
        String isSecureString = " Secure; ";
        if (!isHTTPS) {
            isSecureString = "";
        }
        return "selectedidp=" + selectedIdp + ";path=" + path + "; Max-Age=" + maxAgeString + " ;Expires=" + expireDateGMTString + " ; " + isSecureString + "HttpOnly";
    }
}

