/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.oidcandoauth.ExtractedTrackerIdResult;
import com.resolution.atlasplugins.samlsso.oidcandoauth.OidcAndOAuthCommonHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlow;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlowResult;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.userauth.AbstractLoginHandler;
import com.resolution.samlwrapper.api.LoginInformation;
import com.resolution.samlwrapper.api.LoginInformationImpl;
import com.resolution.samlwrapper.api.exception.SamlAuthenticationException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.StringUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOidcAndOAuthServlet
extends BasicServlet {
    private final AbstractLoginHandler loginHandler;
    private final Logger logger = LoggerFactory.getLogger(AbstractOidcAndOAuthServlet.class);
    protected final AuthenticationTrackerRepository trackerRepository;

    @Inject
    protected AbstractOidcAndOAuthServlet(AuthenticationTrackerRepository trackerRepository, SamlSsoService samlSsoService, TemplateRenderer renderer, AbstractLoginHandler loginHandler) {
        super(samlSsoService, renderer);
        this.loginHandler = loginHandler;
        this.trackerRepository = trackerRepository;
    }

    @Override
    public void processRequest(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) {
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.sendError(resp, null, "This servlet does not accept GET requests", null);
        }
        catch (IOException e) {
            this.logger.error("Something went wrong when trying to send an error to the user", (Throwable)e);
        }
    }

    protected void handleLogin(HttpServletRequest req, HttpServletResponse resp, AuthenticationTracker tracker, OAuth2RunningIdpConfiguration oauthRunningIdpConfiguration, StructuredData userClaims) {
        HttpSession session = req.getSession(true);
        String subClaim = OidcAndOAuthCommonHelpers.getSubClaimOrNull(userClaims);
        LoginInformationImpl loginInformation = new LoginInformationImpl(subClaim, userClaims, oauthRunningIdpConfiguration.getClientId(), tracker.getOriginalUrl(), null);
        tracker.setLoginInformation((LoginInformation)loginInformation);
        session.setAttribute("samlSessionIndex", (Object)loginInformation.getSessionIndex());
        session.setAttribute("identityProvider", (Object)oauthRunningIdpConfiguration.getIdpId());
        session.setAttribute("samlNameID", (Object)subClaim);
        try {
            this.loginHandler.login(req, resp, (LoginInformation)loginInformation, tracker, loginInformation.getSessionIndex(), loginInformation.getNameId(), oauthRunningIdpConfiguration.getId().toString());
        }
        catch (SamlAuthenticationException | IOException e) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Could not login user because: {}", new Object[]{e.getMessage()});
            this.showGeneralErrorToUser(resp, tracker);
        }
    }

    private void showGeneralErrorToUser(HttpServletResponse resp, AuthenticationTracker tracker) {
        try {
            this.sendErrorWithTracker(resp, null, "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs", tracker);
        }
        catch (IOException ex) {
            this.logger.error("Something went wrong when trying to send an error message to the user", (Throwable)ex);
        }
    }

    protected void handleReauthentication(HttpServletRequest req, HttpServletResponse resp, AuthenticationTracker tracker, OAuth2RunningIdpConfiguration oauthRunningIdpConfiguration, StructuredData userClaims) {
        LoginInformationImpl loginInformation = new LoginInformationImpl(OidcAndOAuthCommonHelpers.getSubClaimOrNull(userClaims), userClaims, oauthRunningIdpConfiguration.getClientId(), tracker.getOriginalUrl(), null);
        tracker.setLoginInformation((LoginInformation)loginInformation);
        tracker.add(this.logger, SAMLAuthenticationTracker.Level.INFO, "This is the response for an additional authentication request", new Object[0]);
        HttpSession session = req.getSession(false);
        if (session == null) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "No session present", new Object[0]);
            tracker.setStatusMessage("No session present");
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            this.showGeneralErrorToUser(resp, tracker);
            return;
        }
        String loggedInSubValue = (String)session.getAttribute("samlNameID");
        if (loggedInSubValue == null || loggedInSubValue.isEmpty()) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Attribute {} is not present in session", new Object[]{"samlNameID"});
            tracker.setStatusMessage("Attribute samlNameID is not present in session");
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            this.showGeneralErrorToUser(resp, tracker);
            return;
        }
        String currentSubValue = loginInformation.getNameId();
        if (currentSubValue == null || currentSubValue.isEmpty() || !Objects.equals(loggedInSubValue, currentSubValue)) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.WARNING, "Sub value {} from ID token does not match the sub value {} in the session", new Object[]{currentSubValue, loggedInSubValue});
            tracker.setStatusMessage("Sub value " + currentSubValue + " from ID Token does not match the Sub value " + loggedInSubValue + " in the session");
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            this.showGeneralErrorToUser(resp, tracker);
            return;
        }
        tracker.setStatusMessage("Re-Authentication was successful");
        tracker.setStatus(SAMLAuthenticationTracker.Status.REAUTHENTICATED);
        try {
            this.loginHandler.showAdditionalAuthenticationResult(tracker, req, resp);
        }
        catch (IOException e) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Could not perform Re-Authentication because: {}", new Object[]{e.getMessage()});
            this.showGeneralErrorToUser(resp, tracker);
        }
    }

    @Nonnull
    protected Optional<ExtractedTrackerIdResult> extractTrackerFromRequest(HttpServletRequest req) {
        String trackerIdAndMaybeReauthFlag = req.getParameter("state");
        if (trackerIdAndMaybeReauthFlag == null || trackerIdAndMaybeReauthFlag.trim().isEmpty()) {
            this.logger.error("Cannot process with login since there is no state");
            return Optional.empty();
        }
        String[] splitted = trackerIdAndMaybeReauthFlag.split(":");
        if (splitted.length == 2) {
            String trackerId = splitted[0];
            String reauth = splitted[1];
            if (trackerId != null && !trackerId.isEmpty() && reauth != null && reauth.trim().equals("REAUTHENTICATE")) {
                return Optional.of(new ExtractedTrackerIdResult(trackerId.trim(), true));
            }
            this.logger.error("Something is wrong for reauth with the paramenters: trackerId='{}' and reauth='{}'", (Object)StringUtil.sanitize((String)trackerIdAndMaybeReauthFlag), (Object)StringUtil.sanitize((String)reauth));
            return Optional.empty();
        }
        return Optional.of(new ExtractedTrackerIdResult(trackerIdAndMaybeReauthFlag.trim()));
    }

    @Nonnull
    protected Optional<String> extractCodeFromRequest(HttpServletRequest req, AuthenticationTracker tracker) {
        String code = req.getParameter("code");
        if (code == null || code.trim().isEmpty()) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Could not find a code token in response, cannot continue", new Object[0]);
            return Optional.empty();
        }
        code = code.trim();
        tracker.add(this.logger, SAMLAuthenticationTracker.Level.DEBUG, "Extracted code from request successfully", new Object[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got the following code from the request (sanitized): {}", (Object)StringUtil.sanitize((String)code));
        }
        return Optional.of(code);
    }

    @Nullable
    protected CommonRunningIdpConfiguration findRunningConfig(@Nonnull AuthenticationTracker tracker) {
        String clientId = tracker.getClientId();
        if (clientId == null) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Retrieved clientId from tracker is null, cannot continue", new Object[0]);
            return null;
        }
        CommonRunningIdpConfiguration idpConfig = this.samlSsoService.getRunningConfiguration().getRunningIdpConfiguration(clientId);
        if (idpConfig == null) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Did not found a config. Cannot continue", new Object[0]);
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            return null;
        }
        return idpConfig;
    }

    @Nullable
    protected StructuredData getUserClaimsFromOAuthFlowResult(AuthenticationTracker tracker, OAuthFlowResult result) {
        if (!result.isSuccess()) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Error during OAuthFlow: {}", new Object[]{result.getErrorMessage()});
            return null;
        }
        StructuredData userClaims = result.getUserClaims();
        if (userClaims.isEmpty()) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "No claims in id_token or user endpoint. Cannot continue with log in.", new Object[0]);
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            return null;
        }
        return userClaims;
    }

    protected abstract boolean configClassMatchesConfigClassForChildServlet(CommonRunningIdpConfiguration var1, AuthenticationTracker var2);

    protected abstract OAuthFlowResult handleSpecificCodeFlow(OAuth2RunningIdpConfiguration var1, String var2, AuthenticationTracker var3, String var4);

    protected void handleCommonRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Optional<ExtractedTrackerIdResult> trackerIdAndReauthResultOptional = this.extractTrackerFromRequest(req);
        if (!trackerIdAndReauthResultOptional.isPresent()) {
            this.sendError(resp, null, "Cannot process with login, please ask your administrator to check the logs", null);
            return;
        }
        ExtractedTrackerIdResult extractedTrackerIdResult = trackerIdAndReauthResultOptional.get();
        String trackerId = extractedTrackerIdResult.getTrackerId();
        AuthenticationTracker tracker = (AuthenticationTracker)this.trackerRepository.get(trackerId, false);
        if (tracker == null) {
            this.logger.error("Could not find tracker in tracker repository, trackerId={}", (Object)trackerId);
            this.sendError(resp, null, "Cannot process with login, please ask your administrator to check the logs", null);
            return;
        }
        CommonRunningIdpConfiguration idpConfig = this.findRunningConfig(tracker);
        if (idpConfig == null) {
            this.sendErrorWithTracker(resp, null, "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs", tracker);
            return;
        }
        if (!this.configClassMatchesConfigClassForChildServlet(idpConfig, tracker)) {
            this.sendErrorWithTracker(resp, null, "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs", tracker);
            return;
        }
        OAuth2RunningIdpConfiguration oauthRunningIdpConfiguration = (OAuth2RunningIdpConfiguration)idpConfig;
        if (oauthRunningIdpConfiguration.getOauthFlow() != OAuthFlow.AUTHN_CODE) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.ERROR, "Unsupported OAuth Flow: {}", new Object[]{oauthRunningIdpConfiguration.getOauthFlow()});
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            this.sendErrorWithTracker(resp, null, "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs", tracker);
            return;
        }
        Optional<String> codeOptional = this.extractCodeFromRequest(req, tracker);
        if (!codeOptional.isPresent()) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.ERROR);
            this.sendErrorWithTracker(resp, null, "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs", tracker);
            return;
        }
        String code = codeOptional.get();
        OAuthFlowResult result = this.handleSpecificCodeFlow(oauthRunningIdpConfiguration, code, tracker, this.samlSsoService.getAbsoluteBaseUrl());
        StructuredData userClaims = this.getUserClaimsFromOAuthFlowResult(tracker, result);
        if (userClaims == null) {
            this.sendErrorWithTracker(resp, null, "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs", tracker);
            return;
        }
        if (extractedTrackerIdResult.isReauthentication()) {
            tracker.add(this.logger, SAMLAuthenticationTracker.Level.DEBUG, "Handling response for reauthentication", new Object[0]);
            this.handleReauthentication(req, resp, tracker, oauthRunningIdpConfiguration, userClaims);
        } else {
            this.handleLogin(req, resp, tracker, oauthRunningIdpConfiguration, userClaims);
        }
    }
}

