/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata.reload;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.resolution.atlasplugins.samlsso.configuration.PluginConfigurationListener;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.metadata.reload.ReloadMetadataJobRunner;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class ReloadMetadataJobScheduler
implements PluginConfigurationListener,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ReloadMetadataJobScheduler.class);
    private static final Random RANDOM = new SecureRandom();
    private static final int MIN_DELAY = 15000;
    private static final int MAX_JITTER = 10000;
    private final SchedulerService schedulerService;
    private final RunningConfiguration pluginConfiguration;
    private int intervalInMinutes = 0;
    private final JobId jobId = JobId.of((String)"com.atlassian.atlasplugins.samlsso.configuration.metadata.reloadjob");

    @Inject
    public ReloadMetadataJobScheduler(@ComponentImport SchedulerService schedulerService, RunningConfiguration pluginConfiguration) {
        this.schedulerService = schedulerService;
        this.pluginConfiguration = pluginConfiguration;
        pluginConfiguration.addListener(this);
    }

    public void destroy() {
        logger.debug("Removing as listener from PluginConfiguration");
        this.pluginConfiguration.removeListener(this);
    }

    public void scheduleMetadataReload() {
        int jitter = RANDOM.nextInt(10000);
        Date firstRun = new Date(System.currentTimeMillis() + 15000L + (long)jitter);
        int intervalInMillis = this.pluginConfiguration.getReloadMetadataIntervalInMinutes() * 60 * 1000;
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)ReloadMetadataJobRunner.JOB_RUNNER_KEY).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            logger.info("Scheduling reload metadata job {} with the interval {}, first run is {} ", new Object[]{this.jobId, intervalInMillis, firstRun});
            this.schedulerService.scheduleJob(this.jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            logger.error("Scheduling reload metadata job failed!", (Throwable)e);
        }
    }

    public void stopMetadataReloadSchedule() {
        logger.info("Unscheduling metadata reload job {}", (Object)this.jobId);
        this.schedulerService.unscheduleJob(this.jobId);
    }

    @Override
    public void configurationUpdated() {
        if (this.pluginConfiguration.getReloadMetadataIntervalInMinutes() != this.intervalInMinutes) {
            this.intervalInMinutes = this.pluginConfiguration.getReloadMetadataIntervalInMinutes();
            this.scheduleMetadataReload();
        } else {
            logger.debug("Reload metadata interval ins unchanged, no need to reschedule");
        }
    }

    @Override
    public void configurationCleared() {
        this.stopMetadataReloadSchedule();
    }
}

