/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.resolution.atlasplugins.samlsso.XMLLoader;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V1ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V2ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V3ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V4ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V5ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V6ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V7ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedConfigurationData;
import com.resolution.samlwrapper.api.metadata.impl.MetadataInformationImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigurationDataLoader {
    private static final Logger logger = LoggerFactory.getLogger(XmlConfigurationDataLoader.class);
    private static final Map<Integer, Class<? extends VersionedConfigurationData>> configurationDataClasses = new HashMap<Integer, Class<? extends VersionedConfigurationData>>();

    public V7ConfigurationData load(String xmlString) {
        ConfigurationDataVersion loadedConfigData = XMLLoader.load(xmlString, ConfigurationDataVersion.class);
        Class<? extends VersionedConfigurationData> configurationDataClass = configurationDataClasses.get(loadedConfigData.version);
        VersionedConfigurationData parsedConfigurationData = XMLLoader.load(xmlString, configurationDataClass);
        if (parsedConfigurationData.getMetadataInformation() == null) {
            parsedConfigurationData.setMetadataInformation(new MetadataInformationImpl());
        }
        V7ConfigurationData migrated = this.migrateToLatestVersion(parsedConfigurationData);
        return this.cleanup(migrated);
    }

    public V7ConfigurationData migrateToLatestVersion(VersionedConfigurationData configurationData) {
        return (V7ConfigurationData)this.migrate(configurationData);
    }

    private VersionedConfigurationData migrate(VersionedConfigurationData configurationData) {
        VersionedConfigurationData migratedConfigurationData = configurationData.migrateToNewerModelVersion();
        if (migratedConfigurationData == null) {
            return configurationData;
        }
        return this.migrate(migratedConfigurationData);
    }

    private V7ConfigurationData cleanup(V7ConfigurationData configurationData) {
        int sizeBefore = configurationData.nonSsoDestinations.size();
        this.cleanEmpty(configurationData.nonSsoDestinations);
        if (configurationData.nonSsoDestinations.size() < sizeBefore) {
            logger.warn("Removed empty nonSsoDestinations");
        }
        sizeBefore = configurationData.enforceSsoDestinations.size();
        this.cleanEmpty(configurationData.enforceSsoDestinations);
        if (configurationData.enforceSsoDestinations.size() < sizeBefore) {
            logger.warn("Removed empty enforceSsoDestinations");
        }
        sizeBefore = configurationData.nonSsoUserAgents.size();
        this.cleanEmpty(configurationData.nonSsoUserAgents);
        if (configurationData.nonSsoUserAgents.size() < sizeBefore) {
            logger.warn("Removed empty nonSsoUserAgents");
        }
        return configurationData;
    }

    private void cleanEmpty(List<String> list) {
        ArrayList<String> tempList = new ArrayList<String>(list.size());
        for (String value : list) {
            if (value.trim().isEmpty()) continue;
            tempList.add(value);
        }
        list.clear();
        list.addAll(tempList);
    }

    static {
        configurationDataClasses.put(1, V1ConfigurationData.class);
        configurationDataClasses.put(2, V2ConfigurationData.class);
        configurationDataClasses.put(3, V3ConfigurationData.class);
        configurationDataClasses.put(4, V4ConfigurationData.class);
        configurationDataClasses.put(5, V5ConfigurationData.class);
        configurationDataClasses.put(6, V6ConfigurationData.class);
        configurationDataClasses.put(7, V7ConfigurationData.class);
    }

    public static class ConfigurationDataVersion {
        public int version = 1;
    }
}

