/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.resolution.atlasplugins.samlsso.AgingMap;
import com.resolution.atlasplugins.samlsso.InternalAdditionalAuthenticationService;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.TokenGenerator;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.samlauth.api.AdditionalAuthenticationData;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import de.resolution.samlauth.api.AdditionalAuthenticationStatus;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={AdditionalAuthenticationService.class})
public class AdditionalAuthenticationServiceImpl
implements InternalAdditionalAuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(AdditionalAuthenticationServiceImpl.class);
    private static final String LAST_STATUS_SESSION_ATTRIBUTE = "lastAddtitionalSamlAuthentication";
    private final AuthenticationTrackerRepository repository;
    private final SamlSsoService samlssoservice;
    private final AgingMap<String, String> confirmationTokenMap = new AgingMap();

    @Inject
    public AdditionalAuthenticationServiceImpl(AuthenticationTrackerRepository repository, SamlSsoService samlSsoService) {
        this.repository = repository;
        this.samlssoservice = samlSsoService;
    }

    public static boolean checkToShowNoIdPSessionMessage(@Nonnull RunningConfiguration runningConfiguration) {
        if (!runningConfiguration.isShowLogoutMessageForWebsudoWhenNoIdPSession()) {
            return false;
        }
        return runningConfiguration.getRunningIdPConfigurations().stream().anyMatch(CommonRunningIdpConfiguration::isEnableAdditionalAuthentication);
    }

    public AdditionalAuthenticationData requestAuthentication(@Nonnull HttpServletRequest servletRequest, @Nonnull String confirmationMessage) {
        if (this.isEnabledAndSamlSession(servletRequest)) {
            AuthenticationTracker tracker = (AuthenticationTracker)this.repository.create();
            tracker.setConfirmationMessage(confirmationMessage);
            String authenticationUrl = this.samlssoservice.getRelativeInitiateSSOUrl() + "?" + "additional" + "&tracker=" + tracker.getTrackerId();
            String statusUrl = this.samlssoservice.getRelativeBaseUrl() + "/rest/samlsso-admin/1.0/additionalauth/status/" + tracker.getTrackerId();
            HttpSession session = servletRequest.getSession(false);
            if (session == null) {
                logger.error("Session is null here, this should never happen.");
                return new AdditionalAuthenticationDataImpl(false, null, null, null);
            }
            session.setAttribute(LAST_STATUS_SESSION_ATTRIBUTE, (Object)tracker.getTrackerId());
            return new AdditionalAuthenticationDataImpl(true, tracker.getTrackerId(), authenticationUrl, statusUrl);
        }
        return new AdditionalAuthenticationDataImpl(false, null, null, null);
    }

    public AdditionalAuthenticationStatus getStatus(@Nonnull String id) {
        AuthenticationTracker tracker = (AuthenticationTracker)this.repository.get(id, false);
        if (tracker == null) {
            return null;
        }
        return new AdditionalAuthenticationStatusImpl(tracker);
    }

    @Override
    @Nonnull
    public InternalAdditionalAuthenticationService.AdditionalAuthenticationEnabledResult getEnablementStatus(@Nonnull HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        boolean showNoIdPSessionMessage = AdditionalAuthenticationServiceImpl.checkToShowNoIdPSessionMessage(this.samlssoservice.getRunningConfiguration());
        if (session == null) {
            return new InternalAdditionalAuthenticationService.AdditionalAuthenticationEnabledResult(false, false, showNoIdPSessionMessage, this.samlssoservice.getLogoutUrl());
        }
        String idpEntityId = (String)session.getAttribute("identityProvider");
        if (idpEntityId == null || idpEntityId.isEmpty()) {
            return new InternalAdditionalAuthenticationService.AdditionalAuthenticationEnabledResult(false, false, showNoIdPSessionMessage, this.samlssoservice.getLogoutUrl());
        }
        CommonRunningIdpConfiguration idpConfig = this.samlssoservice.getRunningConfiguration().getRunningIdpConfiguration(idpEntityId);
        if (idpConfig == null) {
            return new InternalAdditionalAuthenticationService.AdditionalAuthenticationEnabledResult(false, false, showNoIdPSessionMessage, this.samlssoservice.getLogoutUrl());
        }
        return new InternalAdditionalAuthenticationService.AdditionalAuthenticationEnabledResult(idpConfig.isEnableAdditionalAuthentication(), idpConfig.isHidePasswordFieldForAdditionalAuthentication(), idpConfig.isEnableAdditionalAuthentication(), this.samlssoservice.getLogoutUrl());
    }

    public boolean isEnabledAndSamlSession(@Nonnull HttpServletRequest httpServletRequest) {
        return this.getEnablementStatus(httpServletRequest).isEnabled();
    }

    public boolean isSameSession(AdditionalAuthenticationStatus status, HttpServletRequest req, boolean clearAfter) {
        HttpSession session = req.getSession(false);
        if (session != null) {
            boolean ispresent;
            boolean bl = ispresent = session.getAttribute("ADDITIONALAUTH_" + status.getId()) != null;
            if (ispresent && clearAfter) {
                session.removeAttribute("ADDITIONALAUTH_" + status.getId());
            }
            return ispresent;
        }
        return false;
    }

    public String createConfirmToken(@Nonnull String statusId) {
        String token = TokenGenerator.create();
        this.confirmationTokenMap.put(token, statusId);
        logger.debug("Created confirmationToken {} for status {}", (Object)token, (Object)statusId);
        return token;
    }

    public boolean confirm(@Nonnull String confirmToken) {
        String statusId = this.confirmationTokenMap.get(confirmToken);
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded status {} from confirmation token {} ", (Object)statusId, (Object)confirmToken.replaceAll("[\n\r\t]", "_"));
        }
        if (statusId != null) {
            this.confirmationTokenMap.remove(confirmToken);
            AuthenticationTracker tracker = (AuthenticationTracker)this.repository.get(statusId, false);
            if (tracker != null) {
                tracker.setConfirmed(true);
                return true;
            }
            logger.warn("Could not find tracker {} to set confirmation", (Object)statusId);
            return false;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("No AuthenticationTracker found for confirmToken {}", (Object)confirmToken.replaceAll("[\n\r\t]", "_"));
        }
        return false;
    }

    @JsonAutoDetect
    public static class AdditionalAuthenticationDataImpl
    implements AdditionalAuthenticationData {
        private final String statusId;
        private final String authenticationUrl;
        private final String statusUrl;
        private final boolean enabled;

        public AdditionalAuthenticationDataImpl(boolean enabled, String statusId, String authenticationUrl, String statusUrl) {
            this.enabled = enabled;
            this.statusId = statusId;
            this.authenticationUrl = authenticationUrl;
            this.statusUrl = statusUrl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getStatusId() {
            return this.statusId;
        }

        public String getAuthenticationUrl() {
            return this.authenticationUrl;
        }

        public String getStatusUrl() {
            return this.statusUrl;
        }
    }

    @JsonAutoDetect
    public static class AdditionalAuthenticationStatusImpl
    implements AdditionalAuthenticationStatus {
        private final AuthenticationTracker tracker;

        public AdditionalAuthenticationStatusImpl(AuthenticationTracker tracker) {
            this.tracker = tracker;
        }

        public String getId() {
            return this.tracker.getTrackerId();
        }

        public boolean isSuccess() {
            return this.tracker.getStatus() == SAMLAuthenticationTracker.Status.REAUTHENTICATED;
        }

        public boolean isDone() {
            return this.tracker.getStatus() != SAMLAuthenticationTracker.Status.NEW && this.tracker.getStatus() != SAMLAuthenticationTracker.Status.IN_PROGRESS;
        }

        public String getStatusMessage() {
            return this.tracker.getStatusMessage();
        }

        public String getUserId() {
            return this.tracker.getUserId();
        }

        public long getLastModified() {
            return this.tracker.getLastModified();
        }

        public boolean isConfirmed() {
            return this.tracker.isConfirmed();
        }
    }
}

