function generateIdPAttributeColumnDescription(frontendState, row) {
    const templates = _.get(frontendState.attributeMapping.currentTemplateMap, row.target.type + "." + row.target.name, []);

    const result = _.find(templates, function (e) {
        return ["source", "target", "transformations"].every(function (prop) {
            return !row.hasOwnProperty(prop) || _.isEqual(row[prop], e.value[prop]);
        });
    });

    if (result !== undefined) {
        return result.label;
    } else {
        if (row.source.type === "FIELD_COMBINER") {
            return "Field Combiner: " + row.source.fieldCombinerExpression;
        } else if (row.source.type === "RETRANSFORM") {
            return "Retransform expression";
        } else if (row.source.type === "FIRST") {
            return "Pick first non empty attribute";
        } else if (row.source.type === "GROOVY") {
            return "Custom Groovy Code";
        } else if (row.source.key === "ATTR_NAMEID") {
            return "Name ID";
        } else if (row.source.type === "UNMAPPED") {
            return "<i>Unmapped</i>";
        } else {
            return row.source.key;
        }
    }
}