/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.onelogin;

import com.fasterxml.jackson.databind.JsonNode;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.commons.data.ListStructuredData;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.ConnectorStorageWrapper;
import de.resolution.usersync.api.FindUserResult;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatusFacade;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.api.exception.GeneralSyncException;
import de.resolution.usersync.api.exception.RequestFailedException;
import de.resolution.usersync.builtin.onelogin.OneLoginConnectorConfiguration;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.AbstractOAuthConnector;
import de.resolution.usersync.spi.oauth.OAuthClientCredentialsFlow;
import de.resolution.usersync.spi.oauth.OAuthFlowFactory;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneLoginConnector
extends AbstractOAuthConnector<OneLoginConnectorConfiguration>
implements OAuthClientCredentialsFlow {
    static final String NAME = "OneLogin";
    private static final Logger logger = LoggerFactory.getLogger(OneLoginConnector.class);
    public static final String ONELOGIN_ATTRIBUTE_ID = "onelogin_ID";
    private static final String DATA_KEY = "data";
    private static final String GROUP_ID_KEY = "group_id";
    private static final String ROLE_ID_KEY = "role_id";
    private static final String MEMBER_OF_KEY = "member_of";
    public static final String STATUS = "status";
    private static final Pattern EXTRACT_CN_PATTERN = Pattern.compile("^CN=([^,]*).*");
    private static final Script COLLECT_ID_NAME_ENTRIES = StructuredData.prepareFind((String)"data.collectEntries{[(it.id): it.name]}");
    private static final Script NEXT_LINK_EXPRESSION = StructuredData.prepareFind((String)"pagination?.next_link");
    private static final Script ROLE_ID_KEY_EXPRESSION = StructuredData.prepareFind((String)"role_id");
    private static final Script GROUP_ID_KEY_EXPRESSION = StructuredData.prepareFind((String)"group_id");
    private static final Script MEMBER_OF_EXPRESSION = StructuredData.prepareFind((String)"member_of");
    private static final Script ERROR_EXPRESSION = StructuredData.prepareFind((String)"status?.error");
    private static final Script STATUS_EXPRESSION = StructuredData.prepareFind((String)"status");
    private static final List<String> CONNECTOR_ATTRIBUTES = Collections.unmodifiableList(Arrays.asList("activated_at", "created_at", "email", "username", "firstname", "group_id", "id", "invalid_login_attempts", "invitation_sent_at", "last_login", "lastname", "locked_until", "comment", "openid_name", "locale_code", "preferred_locale_code", "password_changed_at", "phone", "status", "updated_at", "distinguished_name", "external_id", "directory_id", "member_of", "samaccountname", "userprincipalname", "manager_ad_id", "manager_user_id", "role_id", "company", "department", "title", "state", "trusted_idp_id", "GROUPS"));
    private static final String LIMIT = "limit";
    private final OAuthClientCredentialsFlow oAuthClientCredentialsFlow;

    OneLoginConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull OneLoginConnectorConfiguration configuration, boolean newConnector, long lastUpdated) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, "/data/usersyncAttributeMappingTemplates/OneLoginConnector.json");
        this.oAuthClientCredentialsFlow = OAuthFlowFactory.createClientCredentialsFlow(this.httpWrapper, connectorService.getBaseUrl(), this.getTokenUrl(), ((OneLoginConnectorConfiguration)this.getConfiguration()).getClientId(), ((OneLoginConnectorConfiguration)this.getConfiguration()).getClientSecret(), this.getScope(), new ConnectorStorageWrapper(this.getUniqueId(), connectorService.getConnectorStorageManager()));
    }

    @Override
    public void refreshAccessTokenIfInvalid() throws AccessTokenException {
        this.oAuthClientCredentialsFlow.refreshAccessTokenIfInvalid();
    }

    @Override
    @Nonnull
    public String getTokenUrl() {
        return String.format("%s/auth/oauth2/v2/token", ((OneLoginConnectorConfiguration)this.configuration).getBaseUrl());
    }

    private void fetchUsers(@Nonnull SyncFunction syncFunction, @Nonnull String url, @Nonnull Map<String, String> groups, @Nonnull Map<String, String> roles, @Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        String nextPageUrl = this.fetchUsersPage(syncFunction, url, groups, roles, syncStatusFacade);
        while (nextPageUrl != null) {
            syncStatusFacade.checkCancel();
            nextPageUrl = this.fetchUsersPage(syncFunction, nextPageUrl, groups, roles, syncStatusFacade);
        }
    }

    @Nullable
    private String fetchUsersPage(@Nonnull SyncFunction syncFunction, @Nonnull String url, @Nonnull Map<String, String> groups, @Nonnull Map<String, String> roles, @Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        ResponseWrapper responseWrapper = this.performGetRequest(url, syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            throw new RequestFailedException("Fetching users failed", responseWrapper.getCode(), responseWrapper.getMessage());
        }
        StructuredData structuredData = responseWrapper.getBodyAsStructuredData();
        this.checkForError(structuredData);
        ListStructuredData userList = structuredData.asMap().get((Object)DATA_KEY).asList();
        for (StructuredData currentUser : userList) {
            syncStatusFacade.checkCancel();
            Collection<String> currentGroups = this.addGroupsAndRoles(currentUser, roles, groups);
            if (OneLoginConnector.matchesRequiredConnectorGroups(((OneLoginConnectorConfiguration)this.configuration).getRequiredConnectorGroups(), currentGroups)) {
                syncFunction.accept(currentUser.asMap());
                continue;
            }
            logger.debug("Required groups don't match, skipping user");
        }
        String nextUrl = structuredData.findString(NEXT_LINK_EXPRESSION);
        logger.debug("Next page url is {}", (Object)nextUrl);
        return nextUrl;
    }

    public Collection<String> addGroupsAndRoles(StructuredData currentUser, Map<String, String> roles, Map<String, String> groups) {
        String groupName;
        StructuredData roleData = currentUser.find(ROLE_ID_KEY_EXPRESSION);
        List roleNames = Collections.emptyList();
        if (roleData != null && roleData.isList()) {
            List roleIds = roleData.asStringList();
            roleNames = roleIds.stream().map(id -> (String)roles.get(String.valueOf(id))).filter(str -> str != null && !str.isEmpty()).collect(Collectors.toList());
        }
        currentUser.put((Object)"roleNames", roleNames);
        List<Object> groupNames = Collections.emptyList();
        String groupId = currentUser.findString(GROUP_ID_KEY_EXPRESSION);
        if (groupId != null && !groupId.isEmpty() && (groupName = groups.get(groupId)) != null) {
            groupNames = Collections.singletonList(groupName);
        }
        currentUser.put((Object)"groupNames", groupNames);
        Set<String> groupsFromMemberOf = this.readGroupsFromMemberOf(currentUser.findString(MEMBER_OF_EXPRESSION));
        currentUser.put((Object)"groupsFromMemberOf", groupsFromMemberOf);
        HashSet<String> groupSet = new HashSet<String>();
        if (((OneLoginConnectorConfiguration)this.configuration).isUseGroupAsGroup()) {
            groupSet.addAll(groupNames);
        }
        if (((OneLoginConnectorConfiguration)this.configuration).isUseRolesAsGroup()) {
            groupSet.addAll(roleNames);
        }
        if (((OneLoginConnectorConfiguration)this.configuration).isUseMemberOfAsGroup()) {
            groupSet.addAll(groupsFromMemberOf);
        }
        currentUser.put((Object)"GROUPS", groupSet);
        return groupSet;
    }

    @Override
    @Nonnull
    public FindUserResult findUser(@Nonnull String identifier, MapStructuredData additionalData) {
        try {
            this.refreshAccessTokenIfInvalid();
        }
        catch (AccessTokenException e) {
            return FindUserResult.failed(e);
        }
        try {
            HttpUrl url = this.getUsersUrlBase().addQueryParameter("username", identifier).build();
            ResponseWrapper responseWrapper = this.performGetRequest(url.toString(), SyncStatusFacade.nullFacade());
            if (responseWrapper.isNotFound()) {
                return FindUserResult.notFound();
            }
            if (!responseWrapper.isSuccess()) {
                return FindUserResult.failed(responseWrapper.getMessage());
            }
            StructuredData responseData = responseWrapper.getBodyAsStructuredData();
            StructuredData userListData = responseData.asMap().get((Object)DATA_KEY);
            ListStructuredData usersList = userListData.asList();
            if (usersList.isEmpty()) {
                return FindUserResult.notFound();
            }
            if (usersList.size() == 1) {
                Map<String, String> groupNames = this.fetchGroupNames(SyncStatusFacade.nullFacade());
                Map<String, String> roleNames = this.fetchRoleNames(SyncStatusFacade.nullFacade());
                StructuredData userData = (StructuredData)usersList.get(0);
                Collection<String> currentGroups = this.addGroupsAndRoles(userData, roleNames, groupNames);
                if (((OneLoginConnectorConfiguration)this.configuration).isIgnoreRequiredConnectorGroupsOnSingleUserSync() || OneLoginConnector.matchesRequiredConnectorGroups(((OneLoginConnectorConfiguration)this.configuration).getRequiredConnectorGroups(), currentGroups)) {
                    return FindUserResult.found(userData);
                }
                return FindUserResult.preFiltered(userData);
            }
            return FindUserResult.notUnique();
        }
        catch (RequestFailedException e) {
            return FindUserResult.failed(e);
        }
    }

    @Nonnull
    public static RateLimitInformation getRateLimitInformation(JsonNode responseData) throws GeneralSyncException {
        try {
            return new RateLimitInformation(Integer.parseInt(responseData.path(DATA_KEY).path("X-RateLimit-Limit").asText()), Integer.parseInt(responseData.path(DATA_KEY).path("X-RateLimit-Remaining").asText()), Integer.parseInt(responseData.path(DATA_KEY).path("X-RateLimit-Reset").asText()));
        }
        catch (NumberFormatException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Fetching rate limit returned the following data: {}", (Object)JSONUtil.asJson((Object)responseData));
            }
            throw new GeneralSyncException("Rate limit endpoint did not return the expected data", e);
        }
    }

    private RateLimitInformation fetchRateLimit(@Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException, GeneralSyncException {
        HttpUrl url = this.getUrlBase().addPathSegment("auth").addPathSegment("rate_limit").build();
        ResponseWrapper responseWrapper = this.performGetRequest(url.toString(), syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            throw new RequestFailedException("Fetching rate limit failed", responseWrapper.getCode(), responseWrapper.getMessage());
        }
        JsonNode responseData = responseWrapper.getBodyAsJsonNode();
        return OneLoginConnector.getRateLimitInformation(responseData);
    }

    @Nonnull
    private HttpUrl.Builder getUrlBase() throws RequestFailedException {
        HttpUrl url = HttpUrl.parse((String)((OneLoginConnectorConfiguration)this.configuration).getBaseUrl());
        if (url == null) {
            throw new RequestFailedException("Invalid base URL configured: " + ((OneLoginConnectorConfiguration)this.configuration).getBaseUrl());
        }
        return url.newBuilder();
    }

    @Nonnull
    private HttpUrl.Builder getUsersUrlBase() throws RequestFailedException {
        return this.getUrlBase().addPathSegments("api/1/users");
    }

    private HttpUrl.Builder getGroupsUrlBase() throws RequestFailedException {
        return this.getUrlBase().addPathSegments("api/1/groups");
    }

    private HttpUrl.Builder getRolesUrlBase() throws RequestFailedException {
        return this.getUrlBase().addPathSegments("api/2/roles").addQueryParameter(LIMIT, "650");
    }

    public Set<String> readGroupsFromMemberOf(@Nullable String memberOf) {
        if (memberOf == null || memberOf.isEmpty()) {
            return Collections.emptySet();
        }
        return Arrays.stream(memberOf.split(";")).filter(str -> !str.isEmpty()).map(str -> EXTRACT_CN_PATTERN.matcher((CharSequence)str).replaceAll("$1")).filter(str -> str != null && !str.isEmpty()).collect(Collectors.toSet());
    }

    @Nonnull
    private Map<String, String> fetchGroupNames(@Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        ResponseWrapper responseWrapper = this.performGetRequest(this.getGroupsUrlBase().build().toString(), syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            throw new RequestFailedException("Fetching group names failed", responseWrapper.getCode(), responseWrapper.getMessage());
        }
        StructuredData structuredData = responseWrapper.getBodyAsStructuredData();
        this.checkForError(structuredData);
        return structuredData.findOrEmpty(COLLECT_ID_NAME_ENTRIES).asStringMap();
    }

    @Nonnull
    private Map<String, String> fetchRoleNames(@Nonnull SyncStatusFacade syncStatusFacade) throws RequestFailedException {
        ResponseWrapper responseWrapper = this.performGetRequest(this.getRolesUrlBase().build().toString(), syncStatusFacade);
        if (!responseWrapper.isSuccess()) {
            throw new RequestFailedException("Fetching role names failed", responseWrapper.getCode(), responseWrapper.getMessage());
        }
        return responseWrapper.getBodyAsStructuredData().findOrEmpty(COLLECT_ID_NAME_ENTRIES).asStringMap();
    }

    @Override
    public void doSync(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        try {
            this.refreshAccessTokenIfInvalid();
        }
        catch (AccessTokenException e) {
            syncStatusFacade.fail("Fetching users failed", e, logger);
        }
        try {
            RateLimitInformation rateLimitInformation = this.fetchRateLimit(syncStatusFacade);
            syncStatusFacade.add("Rate limit is " + rateLimitInformation.getRateLimit() + " calls, " + rateLimitInformation.getRateLimitRemaining() + " calls remaining, reset in " + rateLimitInformation.getRateLimitResetIn() + " seconds.", SyncStatusFacade.LogLevel.INFO, logger);
            if (((OneLoginConnectorConfiguration)this.configuration).getMinRemainingRateLimit() > 0 && rateLimitInformation.getRateLimitRemaining() < ((OneLoginConnectorConfiguration)this.configuration).getMinRemainingRateLimit()) {
                syncStatusFacade.fail("Remaining rate limit " + rateLimitInformation.getRateLimitRemaining() + " is below the configured minimum remaining rate limit " + ((OneLoginConnectorConfiguration)this.configuration).getMinRemainingRateLimit(), logger);
                return;
            }
            Map<String, String> groups = this.fetchGroupNames(syncStatusFacade);
            Map<String, String> roles = this.fetchRoleNames(syncStatusFacade);
            String url = this.getUsersUrlBase().build().toString();
            this.fetchUsers(syncFunction, url, groups, roles, syncStatusFacade);
        }
        catch (GeneralSyncException | RequestFailedException e) {
            syncStatusFacade.fail(e.getMessage(), e, logger);
        }
    }

    @Override
    @Nonnull
    public Set<String> getScope() {
        return new HashSet<String>();
    }

    @Override
    public boolean reauthenticateConnector() {
        return this.oAuthClientCredentialsFlow.reauthenticateConnector();
    }

    @Override
    public void resetAuthorization() {
        this.oAuthClientCredentialsFlow.resetAuthorization();
    }

    @Override
    public void refreshAccessToken() throws AccessTokenException {
        this.oAuthClientCredentialsFlow.refreshAccessToken();
    }

    @Override
    public void validateToken(@Nonnull String token, @Nullable String expiryDate) throws AccessTokenException {
        this.oAuthClientCredentialsFlow.validateToken(token, expiryDate);
    }

    @Override
    @Nonnull
    public Class<OneLoginConnectorConfiguration> getConfigurationClass() {
        return OneLoginConnectorConfiguration.class;
    }

    @Override
    @Nonnull
    public String getTypeDisplayName() {
        return NAME;
    }

    @Override
    @Nonnull
    public List<String> getConnectorAttributes() {
        return CONNECTOR_ATTRIBUTES;
    }

    @Override
    public boolean isAllowCustomConnectorAttributes() {
        return true;
    }

    private void checkForError(StructuredData structuredData) throws RequestFailedException {
        String isErrorString = structuredData.findString(ERROR_EXPRESSION);
        if (Boolean.parseBoolean(isErrorString)) {
            throw new RequestFailedException("Status indicates error: " + structuredData.findString(STATUS_EXPRESSION));
        }
    }

    @Override
    @Nonnull
    public List<ConnectionTestResultEntity.EndpointResult> doConnectionTest() {
        ResponseWrapper resp;
        String url;
        ArrayList<ConnectionTestResultEntity.EndpointResult> tests = new ArrayList<ConnectionTestResultEntity.EndpointResult>();
        ConnectionTestResultEntity.EndpointResult accessTokenTest = this.doAccessTokenConnectionTest();
        tests.add(accessTokenTest);
        if (!accessTokenTest.isSuccess()) {
            return tests;
        }
        try {
            url = this.getUsersUrlBase().addQueryParameter(LIMIT, "1").build().toString();
            resp = this.performGetRequest(url, false, false, SyncStatusFacade.nullFacade());
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Users", url, resp.isSuccess(), String.valueOf(resp.getCode()), resp.getBody()));
        }
        catch (RequestFailedException e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Users", "", false, "FAIL", e.getMessage()));
        }
        try {
            url = this.getGroupsUrlBase().addQueryParameter(LIMIT, "1").build().toString();
            resp = this.performGetRequest(url, false, false, SyncStatusFacade.nullFacade());
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Groups", url, resp.isSuccess(), String.valueOf(resp.getCode()), resp.getBody()));
        }
        catch (RequestFailedException e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Groups", "", false, "FAIL", e.getMessage()));
        }
        try {
            url = this.getUrlBase().addPathSegments("api/2/roles").addQueryParameter(LIMIT, "1").build().toString();
            resp = this.performGetRequest(url, false, false, SyncStatusFacade.nullFacade());
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Roles", url, resp.isSuccess(), String.valueOf(resp.getCode()), resp.getBody()));
        }
        catch (RequestFailedException e) {
            tests.add(ConnectionTestResultEntity.EndpointResult.create("Fetch Roles", "", false, "FAIL", e.getMessage()));
        }
        return tests;
    }

    @Override
    @Nonnull
    public ConnectionTestResultEntity.EndpointResult doAccessTokenConnectionTest() {
        return this.oAuthClientCredentialsFlow.doAccessTokenConnectionTest();
    }

    public static class RateLimitInformation {
        private final int rateLimit;
        private final int rateLimitRemaining;
        private final int rateLimitResetIn;

        public RateLimitInformation(int rateLimit, int rateLimitRemaining, int rateLimitResetIn) {
            this.rateLimit = rateLimit;
            this.rateLimitRemaining = rateLimitRemaining;
            this.rateLimitResetIn = rateLimitResetIn;
        }

        public int getRateLimit() {
            return this.rateLimit;
        }

        public int getRateLimitRemaining() {
            return this.rateLimitRemaining;
        }

        public int getRateLimitResetIn() {
            return this.rateLimitResetIn;
        }
    }
}

