function generateCredsAndRequiredTabName(frontendState) {
    const type = _.get(frontendState, "us.currentConnector.type", undefined);

    if (type === undefined || type === '') {
        console.error("Undefined connector type")
        return "Credentials and Options";
    }

    if (type === "de.resolution.usersync.builtin.groovyconnector.GroovyConnector") {
        return 'Code';
    }

    if (type === "de.resolution.usersync.builtin.jit.JitConnector"
        || type === "de.resolution.usersync.builtin.excel.ExcelExporterConnector"
        || type === "de.resolution.usersync.builtin.excel.ExcelImporterConnector"
        || type === "de.resolution.usersync.builtin.testconnector.TestConnector"
        || type === "de.resolution.usersync.builtin.disableInactive.DisableInactiveUsersConnector") {
        return "General Settings";
    }

    return "Credentials and Options";
}
