/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.api;

import de.resolution.commons.data.StructuredData;
import de.resolution.usersync.api.exception.UserFindFailedException;
import de.resolution.usersync.external.api.model.ExternalSyncSingleUserResult;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FindUserResult {
    private final StructuredData attributesFromConnector;
    private final Exception exception;
    private final ExternalSyncSingleUserResult.Status status;

    public static FindUserResult filtered(StructuredData attributesFromConnector) {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.FILTERED, attributesFromConnector, null);
    }

    public static FindUserResult preFiltered(StructuredData attributesFromConnector) {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.PREFILTERED, attributesFromConnector, null);
    }

    public static FindUserResult found(StructuredData attributesFromConnector) {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.FOUND, attributesFromConnector, null);
    }

    public static FindUserResult failed(Exception ex) {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.FAILED, null, ex);
    }

    public static FindUserResult failed(@Nullable String message) {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.FAILED, null, new UserFindFailedException(message));
    }

    public static FindUserResult notFound() {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.NOT_FOUND, null, null);
    }

    public static FindUserResult notUnique() {
        return new FindUserResult(ExternalSyncSingleUserResult.Status.NOT_UNIQUE, null, null);
    }

    private FindUserResult(@Nonnull ExternalSyncSingleUserResult.Status status, @Nullable StructuredData attributesFromConnector, @Nullable Exception exception) {
        this.status = status;
        this.attributesFromConnector = attributesFromConnector == null ? StructuredData.create() : attributesFromConnector;
        this.exception = exception;
    }

    @Nonnull
    public StructuredData getAttributesFromConnector() {
        return this.attributesFromConnector;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public ExternalSyncSingleUserResult.Status getStatus() {
        return this.status;
    }
}

