/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.userauth;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.seraph.auth.Authenticator;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.resolution.atlasplugins.samlsso.auditlog.AuditLogService;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerImpl;
import com.resolution.atlasplugins.samlsso.userauth.AbstractAuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent(value="authenticatorHook")
public class JiraAuthenticatorHook
extends AbstractAuthenticatorHook {
    private final Logger logger = LoggerFactory.getLogger(JiraAuthenticatorHook.class);
    private final DefaultAuthenticator authenticator;
    private final EventPublisher eventPublisher;
    private final UserManager userManager;
    private final LoginService loginService;

    @Inject
    public JiraAuthenticatorHook(@Nonnull @JiraImport EventPublisher eventPublisher, @Nonnull @JiraImport(value="jiraUserManager") UserManager userManager, @Nonnull @JiraImport LoginService loginService, AuditLogService auditLogService) {
        super(auditLogService);
        this.eventPublisher = eventPublisher;
        this.userManager = userManager;
        Authenticator originalAuthenticator = SecurityConfigFactory.getInstance().getAuthenticator();
        if (!(originalAuthenticator instanceof DefaultAuthenticator)) {
            this.authenticator = null;
            throw new AuthenticatorHookException("This authenticator of type " + originalAuthenticator.getClass().getCanonicalName() + "is not a DefaultAuthenticator.", (AuthenticationTracker)new AuthenticationTrackerImpl("INITIAL"));
        }
        this.authenticator = (DefaultAuthenticator)originalAuthenticator;
        this.loginService = loginService;
    }

    @Override
    @Nonnull
    public String getAuthenticatorClass() {
        return this.authenticator.getClass().getCanonicalName();
    }

    @Override
    public boolean isCrowdAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "com.atlassian.jira.security.login.SSOSeraphAuthenticator");
    }

    @Override
    public boolean isDenyPasswordAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "de.resolution.samlsso.authenticator.JiraDenyPasswordAuthenticator");
    }

    @Override
    public boolean isNoSysadminDenyPasswordAuthenticator() {
        return Objects.equals(this.authenticator.getClass().getCanonicalName(), "de.resolution.samlsso.authenticator.JiraDenyPasswordForSysadminsAuthenticator");
    }

    @Override
    public boolean doAuthoriseUserAndEstablishSession(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Principal principal, boolean sdCustomerLogin, @Nonnull AuthenticationTracker tracker) {
        if (principal == null) {
            this.logger.error("Principal must not be null!");
            return false;
        }
        ApplicationUser applicationUser = this.userManager.getUserByName(principal.getName());
        if (applicationUser == null) {
            throw new AuthenticatorHookException("Could not load application user for principal " + principal.getName(), tracker);
        }
        if (!applicationUser.isActive()) {
            throw new AuthenticatorHookException("User is not active", tracker);
        }
        boolean authenticated = sdCustomerLogin ? this.loginSdCustomer(httpServletRequest, principal) : this.loginUser(httpServletRequest, httpServletResponse, principal, tracker);
        if (authenticated) {
            LoginEvent loginEvent = new LoginEvent(applicationUser);
            this.loginService.updateLastLoginTime(applicationUser);
            this.loginService.resetFailedLoginCount(applicationUser);
            this.eventPublisher.publish((Object)loginEvent);
        }
        return authenticated;
    }

    @Override
    protected DefaultAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Override
    public boolean isLoggedInUser(@Nonnull HttpServletRequest httpServletRequest) {
        return ComponentAccessor.getJiraAuthenticationContext().isLoggedInUser();
    }

    private boolean loginUser(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull Principal principal, @Nonnull AuthenticationTracker tracker) {
        this.logger.debug("Invoking authoriseUserAndEstablishSession for {}", (Object)principal.getName());
        try {
            Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
            String methodName = "authoriseUserAndEstablishSession";
            Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Principal.class};
            Object[] parameters = new Object[]{httpServletRequest, httpServletResponse, principal};
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, parameterTypes);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.authenticator, parameters);
            if (returnValue instanceof Boolean) {
                return (Boolean)returnValue;
            }
            throw new AuthenticatorHookException("Authenticator method did not return a boolean, but a " + returnValue.getClass().getCanonicalName(), tracker);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
            throw new AuthenticatorHookException(e, tracker);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticatorHookException(e.getCause(), tracker);
        }
    }

    private boolean loginSdCustomer(@Nonnull HttpServletRequest httpServletRequest, @Nonnull Principal principal) {
        this.logger.debug("Adding SD-Customer {} to session context and returning true", (Object)principal.getName());
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute("seraph_defaultauthenticator_user", (Object)principal);
        httpSession.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
        return true;
    }
}

