/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/nosso")
@Component
public class EnableNossoRestResource {
    private final RunningConfiguration pluginConfiguration;
    private final PrivilegeChecker privilegeChecker;

    @Inject
    public EnableNossoRestResource(PrivilegeChecker privilegeChecker, RunningConfiguration pluginConfiguration) {
        this.privilegeChecker = privilegeChecker;
        this.pluginConfiguration = pluginConfiguration;
    }

    @GET
    @Produces(value={"application/json"})
    public Response status() throws JsonProcessingException {
        boolean status = this.pluginConfiguration.isNossoEnabled();
        String message = status ? "Nosso is enabled" : "Nosso is disabled";
        return Response.ok((Object)Utils.asJson(new EnableNossoResult(message, status))).cacheControl(Utils.ccNoCache).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/off")
    public Response disableNosso(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        if (!this.pluginConfiguration.isNossoEnabled()) {
            return Response.notModified().cacheControl(Utils.ccNoCache).build();
        }
        if (this.pluginConfiguration.isValid()) {
            this.pluginConfiguration.setNossoEnabled(false);
            this.pluginConfiguration.store();
            this.pluginConfiguration.fireConfigurationUpdated();
            return Response.ok((Object)Utils.asJson(new EnableNossoResult("Nosso has been disabled", false))).cacheControl(Utils.ccNoCache).build();
        }
        return Response.serverError().entity((Object)Utils.asJson(new EnableNossoResult("Configuration is invalid, nosso has NOT been disabled.", false))).cacheControl(Utils.ccNoCache).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/on")
    public Response enableNosso(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkPrivileges(request, this.privilegeChecker.getPrivilegeFactory().isSysadmin());
        if (this.pluginConfiguration.isNossoEnabled()) {
            return Response.notModified().cacheControl(Utils.ccNoCache).build();
        }
        this.pluginConfiguration.setNossoEnabled(true);
        this.pluginConfiguration.store();
        this.pluginConfiguration.fireConfigurationUpdated();
        return Response.ok((Object)Utils.asJson(new EnableNossoResult("Nosso has been enabled.", true))).cacheControl(Utils.ccNoCache).build();
    }

    public static class EnableNossoResult {
        public String message;
        public boolean status;

        public EnableNossoResult(String message, boolean status) {
            this.message = message;
            this.status = status;
        }
    }
}

