/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi.oauth;

import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.util.StringUtil;
import de.resolution.usersync.api.ConnectorStorageWrapper;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.rest.entities.ConnectionTestResultEntity;
import de.resolution.usersync.spi.oauth.AbstractOAuthFlow;
import de.resolution.usersync.spi.oauth.OAuthAuthorizationCodeFlow;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuthAuthorizationCodeFlowImpl
extends AbstractOAuthFlow
implements OAuthAuthorizationCodeFlow {
    public static final String RELATIVE_AUTHORIZE_URL = "/plugins/servlet/de.resolution.usersync/oauth2/authorize";
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthorizationCodeFlowImpl.class);
    @Nonnull
    private final String authorizeUrl;
    @Nonnull
    private final String state;

    protected OAuthAuthorizationCodeFlowImpl(@Nonnull HTTPWrapper httpWrapper, @Nonnull String baseUrl, @Nonnull String tokenUrl, @Nonnull String authorizeUrl, @Nullable String clientId, @Nullable String clientSecret, @Nonnull Set<String> scope, @Nonnull String state, @Nonnull ConnectorStorageWrapper connectorStorageWrapper) {
        super(httpWrapper, baseUrl, tokenUrl, clientId, clientSecret, scope, connectorStorageWrapper);
        this.authorizeUrl = authorizeUrl;
        this.state = state;
    }

    @Override
    public void requestAccessToken(@Nonnull String code) throws AccessTokenException {
        if (StringUtil.isNullOrEmpty((String)this.clientId) || StringUtil.isNullOrEmpty((String)this.clientSecret)) {
            logger.error("Invalid configuration, cannot request access token.");
            throw new AccessTokenException("Invalid configuration. Client Id and/or Client secret are empty");
        }
        HashMap<Object, Object> formData = new HashMap<Object, Object>();
        formData.put("grant_type", "authorization_code");
        formData.put("code", code);
        formData.put("client_id", this.clientId);
        formData.put("client_secret", this.clientSecret);
        formData.put("redirect_uri", this.baseUrl + RELATIVE_AUTHORIZE_URL);
        this.executeTokenRequest(formData);
    }

    @Override
    public void refreshAccessToken() throws AccessTokenException {
        if (StringUtil.isNullOrEmpty((String)this.clientId) || StringUtil.isNullOrEmpty((String)this.clientSecret)) {
            logger.error("Invalid configuration, cannot request access token.");
            throw new AccessTokenException("Invalid configuration. Client Id and/or Client secret are empty");
        }
        String refreshToken = this.connectorStorageWrapper.getValue("REFRESH_TOKEN").orElseThrow(() -> new AccessTokenException("Could not refresh access token because refresh token is missing."));
        HashMap<Object, Object> formData = new HashMap<Object, Object>();
        formData.put("grant_type", "refresh_token");
        formData.put("client_id", this.clientId);
        formData.put("client_secret", this.clientSecret);
        formData.put("refresh_token", refreshToken);
        formData.put("redirect_uri", this.baseUrl + RELATIVE_AUTHORIZE_URL);
        formData.put("scope", String.join((CharSequence)" ", this.getScope()));
        this.executeTokenRequest(formData);
    }

    @Override
    @Nullable
    public String getAuthorizationCodeUrl() {
        if (StringUtil.isNullOrEmpty((String)this.clientId)) {
            logger.debug("Client ID is not set yet, returning null");
            return null;
        }
        HttpUrl httpUrl = HttpUrl.parse((String)this.getAuthorizeUrl());
        if (httpUrl == null) {
            throw new NullPointerException("Parsing url returned null");
        }
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder().addQueryParameter("client_id", this.clientId).addQueryParameter("redirect_uri", this.baseUrl + RELATIVE_AUTHORIZE_URL).addQueryParameter("access_type", "offline").addQueryParameter("state", this.state).addQueryParameter("response_type", "code").addQueryParameter("prompt", "consent").addQueryParameter("scope", String.join((CharSequence)" ", this.getScope()));
        return urlBuilder.build().toString();
    }

    @Override
    public boolean isAuthorizationRequired() {
        return !this.connectorStorageWrapper.getValue("REFRESH_TOKEN").isPresent();
    }

    @Override
    @Nonnull
    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    @Override
    @Nonnull
    public ConnectionTestResultEntity.EndpointResult doAccessTokenConnectionTest() {
        if (!this.isAuthorizationRequired()) {
            return ConnectionTestResultEntity.EndpointResult.create("Authorization Valid", "", true, "OK", null);
        }
        return ConnectionTestResultEntity.EndpointResult.createError("Authorization Valid", "", false, "FAIL", null, "Please start the re-authorization, there is no access token present");
    }
}

