/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.spi;

import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.api.exception.AccessTokenException;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.spi.AbstractHTTPConnector;
import de.resolution.usersync.spi.OAuthConnectorConfiguration;
import de.resolution.usersync.spi.oauth.OAuthFlow;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthConnector<T extends OAuthConnectorConfiguration>
extends AbstractHTTPConnector<T>
implements OAuthFlow {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthConnector.class);

    protected AbstractOAuthConnector(@Nonnull ConnectorService connectorService, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull T configuration, boolean newConnector, long lastUpdated, @Nullable String pathToAttributeMappingTemplate) throws ConfigurationFailedException {
        super(connectorService, atlasUserAdapter, configuration, newConnector, lastUpdated, pathToAttributeMappingTemplate);
    }

    @Override
    @Nonnull
    protected String getAuthorizationHeaderValue() throws AccessTokenException {
        String accessToken = this.getConnectorStorageValue("ACCESS_TOKEN").orElseThrow(() -> new AccessTokenException("Access token is not present in storage."));
        String expiryDate = this.getConnectorStorageValue("ACCESS_TOKEN_EXPIRY_DATE").orElse(null);
        this.validateToken(accessToken, expiryDate);
        return "Bearer " + accessToken;
    }
}

