/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.auditlog;

import com.atlassian.audit.entity.ChangedValue;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlascompat.factory.util.Version;
import de.resolution.commons.util.DiffUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogUtil.class);
    public static final Version MINIMAL_JIRA_VERSION = Version.of((String)"8.12.0");
    public static final Version MINIMAL_CONFLUENCE_VERSION = Version.of((String)"7.5.0");
    public static final Version MINIMAL_BITBUCKET_VERSION = Version.of((String)"7.2.0");
    public static final String REDACTED = "<SENSIBLE_DATA_REMOVED>";
    public static final String PLATFORM_BITBUCKET = "bitbucket";

    private AuditLogUtil() {
    }

    public static List<ChangedValue> toChangedValues(@Nonnull List<DiffUtil.Change> changes, @Nonnull Collection<String> pathsToIgnore, @Nonnull Collection<String> pathsToRedact) {
        Stream<DiffUtil.Change> changesWithoutIgnoredPaths = changes.stream().filter(change -> pathsToIgnore.stream().noneMatch(path -> change.getPath().matches((String)path)));
        Stream<DiffUtil.Change> changesWithRedactedData = changesWithoutIgnoredPaths.map(change -> {
            if (pathsToRedact.stream().anyMatch(path -> change.getPath().matches((String)path))) {
                return new DiffUtil.Change(change.getPath(), REDACTED, REDACTED);
            }
            return change;
        });
        return changesWithRedactedData.map(change -> ChangedValue.fromI18nKeys((String)change.getPath()).from(change.getFrom()).to(change.getTo()).build()).collect(Collectors.toList());
    }

    public static boolean supportsAuditLogApi(AtlasCompatApiFactory atlasCompatApiFactory) {
        String platformId = atlasCompatApiFactory.getPlatformApplicationId();
        Version version = Version.of((String)atlasCompatApiFactory.getPlatformApplicationVersion());
        if (platformId.equals("jira") && version.compareTo(MINIMAL_JIRA_VERSION) >= 0 || platformId.equals("conf") && version.compareTo(MINIMAL_CONFLUENCE_VERSION) >= 0 || platformId.equals(PLATFORM_BITBUCKET) && version.compareTo(MINIMAL_BITBUCKET_VERSION) >= 0) {
            logger.debug("{} {} {} should support audit logging.", new Object[]{platformId, atlasCompatApiFactory.getPlatformApplicationDisplayName(), version});
            return true;
        }
        logger.warn("Audit logging is not supported in {} {} {}.", new Object[]{platformId, atlasCompatApiFactory.getPlatformApplicationDisplayName(), version});
        return false;
    }
}

