/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V4IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedIdPConfiguration;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticationAttribute;
import com.resolution.samlwrapper.api.SAMLWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class V3IdpConfiguration
implements Comparable<V3IdpConfiguration>,
VersionedIdPConfiguration {
    public Integer id = null;
    public Integer weight;
    public String name;
    public String description;
    public String postBindingURL;
    public String postBindingLogoutURL;
    public String redirectBindingURL;
    public String redirectBindingLogoutURL;
    public SAMLWrapper.Binding selectedLoginBinding = SAMLWrapper.Binding.POST;
    public LogoutBinding selectedLogoutBinding = LogoutBinding.DISABLE;
    public SAMLWrapper.NameIdFormat nameIdFormatInRequest = SAMLWrapper.NameIdFormat.NONE;
    public String entityId;
    @XmlElementWrapper(name="certificates")
    @XmlElement(name="certificate")
    public List<String> certificates = new ArrayList<String>();
    public boolean useridMatchesNameId = true;
    public String relayStateParameterName = "RelayState";
    public String useridAttribute = null;
    public String fullnameAttribute = null;
    public String emailAttribute = null;
    public String groupAttribute = null;
    public AuthenticationAttribute authenticationAttribute = AuthenticationAttribute.USERNAME;
    @XmlElementWrapper(name="additionalAttributes")
    public Map<String, String> additionalAttributes = new HashMap<String, String>();
    @XmlElementWrapper(name="groupsForNewUsers")
    @XmlElement(name="groupForNewUsers")
    public List<String> groupsForNewUsers = new ArrayList<String>();
    @XmlElementWrapper(name="groupsForNewSdCustomers")
    @XmlElement(name="groupForNewSdCustomers")
    public List<String> groupsForNewSdCustomers = new ArrayList<String>();
    public String useridTransformationRegex;
    public String useridTransformationReplacement;
    public Long directoryIdForNewUsers = 1L;
    public boolean removeFromGroups = false;
    public boolean updateExisting = false;
    public boolean enableUserUpdate = false;
    public boolean lowercaseConvert = false;
    public boolean lowercaseConvertGroups = false;
    public boolean signRequests = true;
    public String metadataurl;
    public String metadataxml;
    public boolean metadataignorecert;
    public boolean useMetadataxml = false;
    public boolean acceptUnsignedLogoutResponse = true;
    public boolean acceptUnsignedLogoutRequest = false;
    public boolean acceptLogoutRequestWithoutSessionIndex = false;
    @XmlElementWrapper(name="attributeMapping")
    public HashMap<String, String> attributeMapping = new HashMap();
    public boolean includeProtocolBindingInRequest = true;
    public String frontendId = null;

    public V3IdpConfiguration() {
    }

    public V3IdpConfiguration(V3IdpConfiguration other) {
        this.id = other.id;
        this.weight = other.weight;
        this.name = other.name;
        this.description = other.description;
        this.postBindingURL = other.postBindingURL;
        this.postBindingLogoutURL = other.postBindingLogoutURL;
        this.redirectBindingURL = other.redirectBindingURL;
        this.redirectBindingLogoutURL = other.redirectBindingLogoutURL;
        this.selectedLoginBinding = other.selectedLoginBinding;
        this.selectedLogoutBinding = other.selectedLogoutBinding;
        this.nameIdFormatInRequest = other.nameIdFormatInRequest;
        this.entityId = other.entityId;
        this.certificates = new ArrayList<String>();
        this.certificates.addAll(other.certificates);
        this.relayStateParameterName = other.relayStateParameterName;
        this.useridMatchesNameId = other.useridMatchesNameId;
        this.useridAttribute = other.useridAttribute;
        this.fullnameAttribute = other.fullnameAttribute;
        this.emailAttribute = other.emailAttribute;
        this.groupAttribute = other.groupAttribute;
        this.acceptUnsignedLogoutResponse = other.acceptUnsignedLogoutResponse;
        this.acceptUnsignedLogoutRequest = other.acceptUnsignedLogoutRequest;
        this.acceptLogoutRequestWithoutSessionIndex = other.acceptLogoutRequestWithoutSessionIndex;
        this.authenticationAttribute = other.authenticationAttribute;
        this.additionalAttributes.putAll(other.additionalAttributes);
        this.groupsForNewUsers = other.groupsForNewUsers;
        this.groupsForNewSdCustomers = other.groupsForNewSdCustomers;
        this.useridTransformationRegex = other.useridTransformationRegex;
        this.useridTransformationReplacement = other.useridTransformationReplacement;
        this.directoryIdForNewUsers = other.directoryIdForNewUsers;
        this.removeFromGroups = other.removeFromGroups;
        this.updateExisting = other.updateExisting;
        this.enableUserUpdate = other.enableUserUpdate;
        this.lowercaseConvert = other.lowercaseConvert;
        this.lowercaseConvertGroups = other.lowercaseConvertGroups;
        this.signRequests = other.signRequests;
        this.includeProtocolBindingInRequest = other.includeProtocolBindingInRequest;
        this.metadataurl = other.metadataurl;
        this.metadataxml = other.metadataxml;
        this.metadataignorecert = other.metadataignorecert;
        this.useMetadataxml = other.useMetadataxml;
        this.attributeMapping = new HashMap();
        this.attributeMapping.putAll(other.attributeMapping);
    }

    @Override
    public V4IdpConfiguration migrateToNewerModelVersion() {
        V4IdpConfiguration idpConfiguration = new V4IdpConfiguration();
        idpConfiguration.id = this.id;
        idpConfiguration.weight = this.weight;
        idpConfiguration.name = this.name;
        idpConfiguration.description = this.description;
        idpConfiguration.postBindingURL = this.postBindingURL;
        idpConfiguration.redirectBindingURL = this.redirectBindingURL;
        idpConfiguration.redirectBindingLogoutURL = this.redirectBindingLogoutURL;
        idpConfiguration.selectedLoginBinding = this.selectedLoginBinding;
        idpConfiguration.postBindingLogoutURL = this.postBindingLogoutURL;
        idpConfiguration.redirectBindingURL = this.redirectBindingURL;
        idpConfiguration.selectedLogoutBinding = V4IdpConfiguration.LogoutBinding.DISABLE;
        switch (idpConfiguration.selectedLogoutBinding) {
            case REDIRECT: {
                if (idpConfiguration.redirectBindingLogoutURL != null && !idpConfiguration.redirectBindingLogoutURL.isEmpty()) break;
                idpConfiguration.selectedLogoutBinding = V4IdpConfiguration.LogoutBinding.DISABLE;
                break;
            }
            case POST: {
                if (idpConfiguration.postBindingLogoutURL != null && !idpConfiguration.postBindingLogoutURL.isEmpty()) break;
                idpConfiguration.selectedLogoutBinding = V4IdpConfiguration.LogoutBinding.DISABLE;
            }
        }
        idpConfiguration.nameIdFormatInRequest = this.nameIdFormatInRequest;
        idpConfiguration.entityId = this.entityId;
        idpConfiguration.certificates = new ArrayList<String>();
        idpConfiguration.certificates.addAll(this.certificates);
        idpConfiguration.relayStateParameterName = this.relayStateParameterName;
        idpConfiguration.useridMatchesNameId = this.useridMatchesNameId;
        idpConfiguration.useridAttribute = this.useridAttribute;
        idpConfiguration.fullnameAttribute = this.fullnameAttribute;
        idpConfiguration.emailAttribute = this.emailAttribute;
        idpConfiguration.groupAttribute = this.groupAttribute;
        idpConfiguration.additionalAttributes.putAll(this.additionalAttributes);
        idpConfiguration.groupsForNewUsers = this.groupsForNewUsers;
        idpConfiguration.groupsForNewSdCustomers = this.groupsForNewSdCustomers;
        idpConfiguration.useridTransformationRegex = this.useridTransformationRegex;
        idpConfiguration.useridTransformationReplacement = this.useridTransformationReplacement;
        idpConfiguration.directoryIdForNewUsers = this.directoryIdForNewUsers;
        idpConfiguration.removeFromGroups = this.removeFromGroups;
        idpConfiguration.updateExisting = this.updateExisting;
        idpConfiguration.enableUserUpdate = this.enableUserUpdate;
        idpConfiguration.enableUserCreation = this.enableUserUpdate;
        idpConfiguration.lowercaseConvert = this.lowercaseConvert;
        idpConfiguration.lowercaseConvertGroups = this.lowercaseConvertGroups;
        idpConfiguration.signRequests = this.signRequests;
        idpConfiguration.includeProtocolBindingInRequest = this.includeProtocolBindingInRequest;
        idpConfiguration.metadataurl = this.metadataurl;
        idpConfiguration.metadataxml = this.metadataxml;
        idpConfiguration.metadataignorecert = this.metadataignorecert;
        idpConfiguration.useMetadataxml = this.useMetadataxml;
        idpConfiguration.attributeMapping = new HashMap();
        idpConfiguration.attributeMapping.putAll(this.attributeMapping);
        return idpConfiguration;
    }

    @Override
    public int compareTo(V3IdpConfiguration other) {
        return this.weight.compareTo(other.weight);
    }

    public static enum LogoutBinding {
        POST,
        REDIRECT,
        DISABLE;

    }
}

