/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.auditlog;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.resolution.atlasplugins.samlsso.auditlog.AuditLogService;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import de.resolution.commons.util.DiffUtil;
import de.resolution.commons.util.JSONUtil;
import de.resolution.usersync.auditlog.AuditLogUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewApiAuditLogService
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(NewApiAuditLogService.class);
    private final AuditService auditService;
    private final Collection<String> pathsToIgnore = Arrays.asList("\\/multiMetadataStatus\\/lastUpdated", "\\/multiMetadataStatus\\/lastUpdatedUTC", "\\/idpConfigurations\\/[0-9]+\\/lastMetadataReload", "\\/multiMetadataStatus");
    private final Collection<String> pathsToRedact = Collections.singletonList("\\/privateKeyPEM");

    public NewApiAuditLogService(AuditService auditService) {
        this.auditService = auditService;
    }

    @Override
    public void logConfigurationUpdate(@Nonnull ConfigurationData oldConfig, @Nonnull ConfigurationData newConfig) {
        List<DiffUtil.Change> changes;
        try {
            changes = DiffUtil.diff((Object)oldConfig, (Object)newConfig);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to calculate diff", (Throwable)e);
                logger.warn("Old: {}", (Object)JSONUtil.asJson((Object)oldConfig));
                logger.warn("New: {}", (Object)JSONUtil.asJson((Object)newConfig));
            }
            changes = Collections.singletonList(new DiffUtil.Change("", "Calculating diff failed: " + e.getMessage(), null));
        }
        List<ChangedValue> changedValues = AuditLogUtil.toChangedValues(changes, this.pathsToIgnore, this.pathsToRedact);
        if (changedValues.isEmpty()) {
            logger.debug("No changed detected");
            return;
        }
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.ECOSYSTEM, (CoverageLevel)CoverageLevel.BASE, (String)"SAML Single Sign On", (String)"Config changed").build();
        AuditResource affectedObject = AuditResource.builder((String)"Configuration", (String)"Configuration").build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).changedValues(changedValues).build();
        this.auditService.audit(event);
    }

    @Override
    public void logLogout(@Nullable String username) {
        if (username == null) {
            logger.debug("No username provided, not logging logout event");
            return;
        }
        AuditType auditType = AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.FULL, (String)"Authentication", (String)"User logged out").build();
        AuditResource affectedObject = AuditResource.builder((String)username, (String)username).build();
        AuditEvent event = AuditEvent.builder((AuditType)auditType).affectedObject(affectedObject).build();
        this.auditService.audit(event);
    }
}

