/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso;

import com.resolution.atlasplugins.samlsso.NameAndValue;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchingUtils {
    public static final Logger logger = LoggerFactory.getLogger(MatchingUtils.class);

    private MatchingUtils() {
    }

    public static boolean containsMatch(Map<String, String> map, Iterable<NameAndValue> namesAndValues, long timeout) throws TimeoutExceededException {
        for (NameAndValue nameAndValue : namesAndValues) {
            if (!map.keySet().contains(nameAndValue.name)) continue;
            String mapValue = map.get(nameAndValue.name);
            if (nameAndValue.value == null || nameAndValue.value.trim().isEmpty()) {
                logger.debug("Name matched {} matched with no pattern and value {}", (Object)nameAndValue.name, (Object)mapValue);
                return true;
            }
            if (!BoundedRegex.matches((String)nameAndValue.value, (String)mapValue, (long)timeout)) continue;
            logger.debug("Name {} matched with pattern {} and value {}", new Object[]{nameAndValue.name, nameAndValue.value, mapValue});
            return true;
        }
        return false;
    }

    public static boolean containsMatch(Iterable<String> values, Iterable<String> regexes, long timeout) throws TimeoutExceededException {
        try {
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                for (String regex : regexes) {
                    if (regex == null || regex.isEmpty() || !BoundedRegex.matches((String)regex, (String)value, (long)timeout)) continue;
                    logger.debug("Value {} matches pattern {}", (Object)value, (Object)regex);
                    return true;
                }
            }
            return false;
        }
        catch (TimeoutExceededException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Exception occured while checking for match, returning false", (Throwable)e);
            return false;
        }
    }
}

