/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.servlet;

import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class RedirectServiceDeskUtil {
    private static final Logger logger = LoggerFactory.getLogger(RedirectServiceDeskUtil.class);
    private final RunningConfiguration pluginConfiguration;

    public RedirectServiceDeskUtil(RunningConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public boolean shouldRedirect(@Nullable String portalId) {
        if (this.pluginConfiguration.getRedirectServiceDeskPortals() == ConfigurationData.RedirectServiceDeskPortals.NONE) {
            logger.debug("ServiceDesk login redirection is disabled, not redirecting");
            return false;
        }
        if (this.pluginConfiguration.getRedirectServiceDeskPortals() == ConfigurationData.RedirectServiceDeskPortals.ALL) {
            logger.debug("ServiceDesk login redirection is enabled for all portals, redirecting");
            return true;
        }
        if (this.pluginConfiguration.getRedirectServiceDeskPortals() == ConfigurationData.RedirectServiceDeskPortals.ALL_BUT_SELECTED) {
            if (portalId != null && this.pluginConfiguration.getServiceDeskPortalsToRedirect().contains(portalId)) {
                logger.debug("ServiceDesk portal {} is listed as portal not to redirect, not redirecting", (Object)portalId);
                return false;
            }
            logger.debug("ServiceDesk portal {} is not listed as portal not to redirect, redirecting", (Object)portalId);
            return true;
        }
        if (this.pluginConfiguration.getRedirectServiceDeskPortals() == ConfigurationData.RedirectServiceDeskPortals.SELECTED) {
            if (portalId != null && this.pluginConfiguration.getServiceDeskPortalsToRedirect().contains(portalId)) {
                logger.debug("ServiceDesk portal {} is listed as portal to redirect, redirecting", (Object)portalId);
                return true;
            }
            logger.debug("ServiceDesk portal {} is not listed as portal to redirect, not redirecting", (Object)portalId);
            return false;
        }
        logger.warn("Unknown redirectServiceDeskPortals value: {}, not redirecting", (Object)this.pluginConfiguration.getRedirectServiceDeskPortals());
        return false;
    }
}

