/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.spring.container.ContainerManager;
import com.resolution.atlasplugins.samlsso.cluster.AbstractClusterNotificator;
import com.resolution.atlasplugins.samlsso.confluence.SAMLSsoPluginEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@ConfluenceComponent(value="clusterNotificator")
public class ConfluenceClusterNotificator
extends AbstractClusterNotificator
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceClusterNotificator.class);
    private final EventPublisher eventPublisher = (EventPublisher)ContainerManager.getComponent((String)"eventPublisher");

    public ConfluenceClusterNotificator() {
        this.eventPublisher.register((Object)this);
    }

    @Override
    public void send(String message) {
        SAMLSsoPluginEvent event = new SAMLSsoPluginEvent(this, message);
        this.eventPublisher.publish((Object)event);
    }

    public static Optional<SAMLSsoPluginEvent> readEvent(@Nonnull ClusterEventWrapper wrapper) {
        try {
            Object eventObject = ClusterEventWrapper.class.getMethod("getEvent", new Class[0]).invoke((Object)wrapper, new Object[0]);
            if (eventObject instanceof SAMLSsoPluginEvent) {
                return Optional.of((SAMLSsoPluginEvent)((Object)eventObject));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Ignoring event of type {}", (Object)eventObject.getClass().getName());
            }
            return Optional.empty();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new FailedToGetEventException(e);
        }
    }

    @EventListener
    public void handleRemoteEvent(ClusterEventWrapper wrapper) {
        ConfluenceClusterNotificator.readEvent(wrapper).ifPresent(event -> {
            String message = event.getMessage();
            logger.debug("Received SAMLSsoPluginEvent with message {}, notifying listeners", (Object)message);
            this.notifiyListeners(message);
        });
    }

    @EventListener
    public void handleLocalEvent(SAMLSsoPluginEvent event) {
        logger.trace("Received local event with message {}, and ignoring it.", (Object)event.getMessage());
    }

    public void destroy() {
        logger.trace("Unregistering from EventPublisher");
        this.eventPublisher.unregister((Object)this);
    }

    public static class FailedToGetEventException
    extends RuntimeException {
        public FailedToGetEventException(Throwable cause) {
            super("Unable to execute method getEvent in ClusterEventWrapper", cause);
        }
    }
}

