/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.oidc;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.oidcandoauth.CaffeineCachedJwkProvider;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.JwksUriProvider;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OidcRunningIdpConfiguration
extends OAuth2RunningIdpConfiguration {
    private final OidcIdpConfigurationData oidcIdpConfigurationData;
    private final CaffeineCachedJwkProvider jwkStore;

    public OidcRunningIdpConfiguration(@Nonnull OidcIdpConfigurationData oidcIdpConfigurationData, @Nullable AtlasUserAdapter atlasUserAdapter, @Nonnull ConfigurationData configData) {
        super(oidcIdpConfigurationData, atlasUserAdapter);
        this.oidcIdpConfigurationData = oidcIdpConfigurationData;
        this.jwkStore = new CaffeineCachedJwkProvider(new JwksUriProvider(oidcIdpConfigurationData.urlForJwtKeyStore), configData.oidcJwksCacheSize, configData.oidcJwksCacheExpiresInMinutes, TimeUnit.MINUTES);
    }

    public String getWellKnownUrl() {
        return this.oidcIdpConfigurationData.wellKnownUrl;
    }

    public String getIssuer() {
        return this.oidcIdpConfigurationData.issuer;
    }

    public String getPublicKeyStoreLink() {
        return this.oidcIdpConfigurationData.urlForJwtKeyStore;
    }

    public List<String> getSupportedScopes() {
        return new ArrayList<String>(this.oidcIdpConfigurationData.supportedScopes);
    }

    public List<String> getSupportedSigningAlgorithms() {
        return new ArrayList<String>(this.oidcIdpConfigurationData.supportedSigningAlgorithms);
    }

    public boolean sendAndVerifyNonce() {
        return this.oidcIdpConfigurationData.sendAndVerifyNonce;
    }

    @Nonnull
    public String getResponseMode() {
        return this.oidcIdpConfigurationData.responseMode;
    }

    @Nullable
    public Jwk getKeyFromKeyStore(@Nullable String kid) throws JwkException {
        if (kid == null) {
            return null;
        }
        return this.jwkStore.get(kid);
    }
}

