/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.usersync.builtin.groovyconnector;

import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.usersync.api.SyncFunction;
import de.resolution.usersync.api.SyncStatus;
import de.resolution.usersync.api.SyncStatusFacade;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SyncWrapper.class);
    @Nonnull
    private final SyncFunction syncFunction;
    @Nonnull
    private final SyncStatusFacade syncStatusFacade;

    public SyncWrapper(@Nonnull SyncFunction syncFunction, @Nonnull SyncStatusFacade syncStatusFacade) {
        this.syncFunction = syncFunction;
        this.syncStatusFacade = syncStatusFacade;
    }

    @Nonnull
    public SyncFunction getSyncFunction() {
        return this.syncFunction;
    }

    public void syncUser(StructuredData userData) {
        this.syncFunction.accept(userData.asMap());
    }

    @Nonnull
    public SyncStatusFacade getSyncStatusFacade() {
        return this.syncStatusFacade;
    }

    @Nullable
    public SyncStatus getSyncStatus() {
        return this.getSyncStatusFacade().getSyncStatus();
    }

    public void fail(String message) {
        this.syncStatusFacade.fail(message, logger);
    }

    public void apply(MapStructuredData userAttributes) {
        this.syncFunction.accept(userAttributes);
    }

    public void log(Object message) {
        this.log(message, SyncStatusFacade.LogLevel.INFO, logger);
    }

    public void log(Object message, SyncStatusFacade.LogLevel logLevel, Logger logger) {
        this.syncStatusFacade.add(message.toString(), logLevel, logger);
    }
}

