/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.frontenddefinition;

import de.resolution.commons.license.PluginProperties;
import de.resolution.reconfigure.Utils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StringLoader {
    private static final Logger logger = LoggerFactory.getLogger(StringLoader.class);

    public static StringLoader create() {
        return StringLoader.create("/", PluginProperties.get((String)"frontendDefinitionPath"));
    }

    public static StringLoader create(@Nullable String classpathBase, @Nullable String filesystemBase) {
        if (classpathBase == null) {
            classpathBase = "/";
        }
        if (filesystemBase != null && !filesystemBase.isEmpty()) {
            logger.warn("Loading files from {} if available", (Object)filesystemBase);
            return new FileAndThenClassPathStringLoader(classpathBase, filesystemBase);
        }
        return new ClassPathStringLoader(classpathBase);
    }

    public abstract String load(String var1);

    public static class FileAndThenClassPathStringLoader
    extends StringLoader {
        private final String fileSystemBasePath;
        private final String basePath;

        public FileAndThenClassPathStringLoader(String basePath, String fileSystemBasePath) {
            this.basePath = basePath;
            this.fileSystemBasePath = fileSystemBasePath;
        }

        @Override
        public String load(String identifier) {
            Path pathToFile = Paths.get(this.fileSystemBasePath, this.basePath, identifier);
            if (pathToFile.toFile().canRead()) {
                logger.warn("Loading {} from file {}", (Object)identifier, (Object)pathToFile);
                try {
                    return new String(Files.readAllBytes(pathToFile));
                }
                catch (IOException e) {
                    logger.warn("Failed to read data from {}, trying to read from classpath", (Object)pathToFile, (Object)e);
                }
            } else {
                logger.debug("Could not read file {}", (Object)pathToFile);
            }
            logger.debug("Reading {} from classpath", (Object)identifier);
            return Utils.readFromClasspath(this.basePath + identifier);
        }
    }

    public static class ClassPathStringLoader
    extends StringLoader {
        private final String basePath;

        public ClassPathStringLoader(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public String load(String identifier) {
            return Utils.readFromClasspath(this.basePath + identifier);
        }
    }
}

