(function () {
    var webSudoWithSAML = window.resolution.webSudoWithSAML;
    var additionalAuthBase = AJS.contextPath() + '/rest/samlsso-admin/1.0/additionalauth';
    var triggerWebsudoUrl = AJS.contextPath() + '/rest/samlsso-admin/1.0/websudo';
    webSudoWithSAML.injectDiv.removeClass();
    webSudoWithSAML.injectDiv.addClass("aui-message aui-message-info");
    webSudoWithSAML.injectDiv.append("<aui-spinner size=\"small\"></aui-spinner>" + WRM.I18n.getText('com.resolution.samlsso.websudo.checkforsaml.message'));

    AJS.$.ajax({
        url: additionalAuthBase + '/enabled',
        dataType: "json",
        success: function (data) {
            webSudoWithSAML.injectDiv.empty();
            if (data.enabled) {
                console.log("This is a SAML-session.");
                addSSOButton(webSudoWithSAML, data.hidePasswordField);
            } else if(data.showNotEnabledMessage) {
                console.log("This is no SAML-session.");

                let logoutLink = "";
                if(data.logoutUrl) {
                    const atlassianToken = document.querySelector('meta[name="atlassian-token"]')?.getAttribute('content');
                    const logoutUrl = data?.logoutUrl?.replace("#TOKEN#", atlassianToken);

                    logoutLink = "<p><a class=\"aui-button\" href=\"" + logoutUrl + "\" >" + WRM.I18n.getText('com.resolution.samlsso.websudo.nosamlsession.logoutlinktext') + "</a></p>"
                }

                webSudoWithSAML.injectDiv.append(
                    AJS.$("<p>" + WRM.I18n.getText('com.resolution.samlsso.websudo.nosamlsession.message')
                        + "</p><p>"+ WRM.I18n.getText('com.resolution.samlsso.websudo.nosamlsession.description') + "</p>"
                        + logoutLink));
            } else {
                webSudoWithSAML.injectDiv.removeClass();
                webSudoWithSAML.injectDiv.empty();
                console.log("Showing the no SAML-session message is disabled.");
            }
        },
        error: function (error) {
            webSudoWithSAML.injectDiv.empty();
            webSudoWithSAML.injectDiv.removeClass();
            webSudoWithSAML.injectDiv.addClass("aui-message aui-message-error");
            webSudoWithSAML.injectDiv.append("<p>" +  WRM.I18n.getText('com.resolution.samlsso.websudo.checkforsaml.failed') + "</p>");
            console.log(error);
        }
    });

    var addSSOButton = function (webSudoWithSAML, hidePasswordField) {
        var newButton = AJS.$(
            "<input>", {
                type: "button",
                class: "aui-button",
                value:  WRM.I18n.getText('com.resolution.samlsso.websudo.button.label')
            }).click(function () {
            requestWebsudoAuthentication();
        });
        webSudoWithSAML.injectDiv.append(
            AJS.$("<p>" + WRM.I18n.getText('com.resolution.samlsso.websudo.samlsession.message') + "</p><p>"+  WRM.I18n.getText('com.resolution.samlsso.websudo.samlsession.description') + "</p>")
        );
        webSudoWithSAML.injectDiv.append("<p>").append(newButton);
        webSudoWithSAML.injectDiv.append("<p><b>" + WRM.I18n.getText('com.resolution.samlsso.websudo.newwindow') + "</b></p>");

        if(hidePasswordField) {
            webSudoWithSAML.loginForm.hide();
        }
    }

    var requestWebsudoAuthentication = function () {
        AJS.$.ajax({
            url: triggerWebsudoUrl,
            type: 'POST',
            dataType: "json",
            contentType: "application/json",
            data: JSON.stringify({'webSudoDestination': webSudoWithSAML.webSudoDestination}),
            success: function (data) {
                webSudoWithSAML.injectDiv.empty();
                webSudoWithSAML.injectDiv.removeClass();
                webSudoWithSAML.injectDiv.addClass("aui-message aui-message-info");
                webSudoWithSAML.injectDiv.append("<p><aui-spinner size=\"small\"></aui-spinner>" + WRM.I18n.getText('com.resolution.samlsso.websudo.waitingforauthentication') + "</p>");
                webSudoWithSAML.injectDiv.append("<p>" + WRM.I18n.getText('com.resolution.samlsso.websudo.authenticateinnewwindow') + "</p>");
                startWebsudoAuthentication(data.authenticationUrl, data.afterAuthenticationUrl);
            },
            error: function (error) {
                webSudoWithSAML.injectDiv.empty();
                webSudoWithSAML.injectDiv.removeClass();
                webSudoWithSAML.injectDiv.addClass("aui-message aui-message-error");
                webSudoWithSAML.injectDiv.append("<p>" + WRM.I18n.getText('com.resolution.samlsso.websudo.requestfailed') + "</p>");
                console.log(error);
            }
        });
    }

    var startWebsudoAuthentication = function (authUrl, afterAuthUrl) {
        var awaitingAuthentication = false;
        window.addEventListener('storage', function (event) {
            if (event.key === 'additionalSAMLAuthentication' && awaitingAuthentication) {
                awaitingAuthentication = false;
                window.location.href = afterAuthUrl;
            }
        });
        awaitingAuthentication = true;
        window.open(authUrl, 'newwindow', 'width=600,height=600,left=200,top=200');
    }
})();


