AJS.$(function() {
    (function() {
        if(!window.resolution) {
            window.resolution = {};
        }
        var webSudoWithSAML = {};
        window.resolution.webSudoWithSAML = webSudoWithSAML;

        // Inject inject_websudo.js if we're on the WebSudo-Page
        webSudoWithSAML.loginForm = AJS.$('form[name="authenticateform"]');
        if(webSudoWithSAML.loginForm .length) {
            var formAction = webSudoWithSAML.loginForm .attr('action');
            if(formAction.includes('doauthenticate.action')) {
                webSudoWithSAML.webSudoDestination = webSudoWithSAML.loginForm.find('input[name="destination"]').val();
                webSudoWithSAML.injectDiv = AJS.$("<div>");
                webSudoWithSAML.loginForm.before(webSudoWithSAML.injectDiv);
                WRM.require("wr!com.resolution.atlasplugins.samlsso.Confluence:injectWebsudoResources-2025-04-02T16:33:13Z");
            }
        }
    })();

    // Pre-populate the username field with the value from the os_username URL parameter in Confluence 9.1
    (function(){
        if(!window.location.pathname.endsWith("login.action")) {
            return;
        }

        const urlParams = new URLSearchParams(window.location.search);
        if(!urlParams.has('os_username')) {
            return;
        }
        const username_to_inject = urlParams.get('os_username');

        let retries = 10;
        const findLoginForm = function () {
            if(retries > 0) {
                const $usernameField = $('#username-field');
                if($usernameField.length) {
                    if($usernameField.attr('value') === '') {
                        $usernameField.attr('value', username_to_inject);

                        // Trigger input and change events to simulate user interaction,
                        // otherwise the field may be cleared when focus is lost.
                        $usernameField[0].dispatchEvent(new Event('input', { bubbles: true }));
                        $usernameField[0].dispatchEvent(new Event('change', { bubbles: true }));

                        $('#password-field').focus();
                    } else {
                        console.debug("## Username field is not empty, nothing to do.");
                    }
                } else {
                    console.debug("## Username field not found, retrying in 100ms");
                    retries -= 1;
                    setTimeout(findLoginForm,100);
                }
            }
        };
        setTimeout(findLoginForm,100);
    })();
});
